/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CL20;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class CL21
extends CL20 {
    public static final int CL_VERSION_2_1 = 1;
    public static final int CL_PLATFORM_HOST_TIMER_RESOLUTION = 2309;
    public static final int CL_DEVICE_IL_VERSION = 4187;
    public static final int CL_DEVICE_MAX_NUM_SUB_GROUPS = 4188;
    public static final int CL_DEVICE_SUB_GROUP_INDEPENDENT_FORWARD_PROGRESS = 4189;
    public static final int CL_QUEUE_DEVICE_DEFAULT = 4245;
    public static final int CL_UNORM_INT_101010_2 = 4320;
    public static final int CL_PROGRAM_IL = 4457;
    public static final int CL_KERNEL_MAX_NUM_SUB_GROUPS = 4537;
    public static final int CL_KERNEL_COMPILE_NUM_SUB_GROUPS = 4538;
    public static final int CL_KERNEL_MAX_SUB_GROUP_SIZE_FOR_NDRANGE = 8243;
    public static final int CL_KERNEL_SUB_GROUP_COUNT_FOR_NDRANGE = 8244;
    public static final int CL_KERNEL_LOCAL_SIZE_FOR_SUB_GROUP_COUNT = 8244;

    protected CL21() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="cl_int")
    public static int clSetDefaultDeviceCommandQueue(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_command_queue") long command_queue) {
        long __functionAddress = CL.getICD().clSetDefaultDeviceCommandQueue;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.check(device);
            Checks.check(command_queue);
        }
        return JNI.callPPPI(context, device, command_queue, __functionAddress);
    }

    public static int nclGetDeviceAndHostTimer(long device, long device_timestamp, long host_timestamp) {
        long __functionAddress = CL.getICD().clGetDeviceAndHostTimer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        return JNI.callPPPI(device, device_timestamp, host_timestamp, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceAndHostTimer(@NativeType(value="cl_device_id") long device, @NativeType(value="cl_ulong *") LongBuffer device_timestamp, @NativeType(value="cl_ulong *") LongBuffer host_timestamp) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)device_timestamp, 1);
            Checks.check((Buffer)host_timestamp, 1);
        }
        return CL21.nclGetDeviceAndHostTimer(device, MemoryUtil.memAddress(device_timestamp), MemoryUtil.memAddress(host_timestamp));
    }

    public static int nclGetHostTimer(long device, long host_timestamp) {
        long __functionAddress = CL.getICD().clGetHostTimer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
        }
        return JNI.callPPI(device, host_timestamp, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetHostTimer(@NativeType(value="cl_device_id") long device, @NativeType(value="cl_ulong *") LongBuffer host_timestamp) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)host_timestamp, 1);
        }
        return CL21.nclGetHostTimer(device, MemoryUtil.memAddress(host_timestamp));
    }

    public static long nclCreateProgramWithIL(long context, long il2, long length, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateProgramWithIL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
        }
        return JNI.callPPPPP(context, il2, length, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_program")
    public static long clCreateProgramWithIL(@NativeType(value="cl_context") long context, @NativeType(value="void const *") ByteBuffer il2, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL21.nclCreateProgramWithIL(context, MemoryUtil.memAddress(il2), il2.remaining(), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long nclCloneKernel(long source_kernel, long errcode_ret) {
        long __functionAddress = CL.getICD().clCloneKernel;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(source_kernel);
        }
        return JNI.callPPP(source_kernel, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_kernel")
    public static long clCloneKernel(@NativeType(value="cl_kernel") long source_kernel, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL21.nclCloneKernel(source_kernel, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static int nclGetKernelSubGroupInfo(long kernel, long device, int param_name, long input_value_size, long input_value, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetKernelSubGroupInfo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(kernel);
        }
        return JNI.callPPPPPPPI(kernel, device, param_name, input_value_size, input_value, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetKernelSubGroupInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_kernel_sub_group_info") int param_name, @Nullable @NativeType(value="void const *") ByteBuffer input_value, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL21.nclGetKernelSubGroupInfo(kernel, device, param_name, Checks.remainingSafe(input_value), MemoryUtil.memAddressSafe(input_value), Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetKernelSubGroupInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_kernel_sub_group_info") int param_name, @Nullable @NativeType(value="void const *") ByteBuffer input_value, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL21.nclGetKernelSubGroupInfo(kernel, device, param_name, Checks.remainingSafe(input_value), MemoryUtil.memAddressSafe(input_value), Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int nclEnqueueSVMMigrateMem(long command_queue, int num_svm_pointers, long svm_pointers, long sizes, long flags, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueSVMMigrateMem;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPJPPI(command_queue, num_svm_pointers, svm_pointers, sizes, flags, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueSVMMigrateMem(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="void const **") PointerBuffer svm_pointers, @Nullable @NativeType(value="size_t const *") PointerBuffer sizes, @NativeType(value="cl_mem_migration_flags") long flags, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(sizes, svm_pointers.remaining());
            Checks.checkSafe(event, 1);
        }
        return CL21.nclEnqueueSVMMigrateMem(command_queue, svm_pointers.remaining(), MemoryUtil.memAddress(svm_pointers), MemoryUtil.memAddressSafe(sizes), flags, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceAndHostTimer(@NativeType(value="cl_device_id") long device, @NativeType(value="cl_ulong *") long[] device_timestamp, @NativeType(value="cl_ulong *") long[] host_timestamp) {
        long __functionAddress = CL.getICD().clGetDeviceAndHostTimer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
            Checks.check(device_timestamp, 1);
            Checks.check(host_timestamp, 1);
        }
        return JNI.callPPPI(device, device_timestamp, host_timestamp, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetHostTimer(@NativeType(value="cl_device_id") long device, @NativeType(value="cl_ulong *") long[] host_timestamp) {
        long __functionAddress = CL.getICD().clGetHostTimer;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(device);
            Checks.check(host_timestamp, 1);
        }
        return JNI.callPPI(device, host_timestamp, __functionAddress);
    }

    @NativeType(value="cl_program")
    public static long clCreateProgramWithIL(@NativeType(value="cl_context") long context, @NativeType(value="void const *") ByteBuffer il2, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateProgramWithIL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPPPP(context, MemoryUtil.memAddress(il2), (long)il2.remaining(), errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_kernel")
    public static long clCloneKernel(@NativeType(value="cl_kernel") long source_kernel, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCloneKernel;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(source_kernel);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPP(source_kernel, errcode_ret, __functionAddress);
    }
}

