/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class JsonFoldParser
implements FoldParser {
    private static final Object OBJECT_BLOCK = new Object();
    private static final Object ARRAY_BLOCK = new Object();

    @Override
    public List<Fold> getFolds(RSyntaxTextArea textArea) {
        Stack<Object> blocks = new Stack<Object>();
        ArrayList<Fold> folds = new ArrayList<Fold>();
        Fold currentFold = null;
        int lineCount = textArea.getLineCount();
        try {
            for (int line = 0; line < lineCount; ++line) {
                for (Token t2 = textArea.getTokenListForLine(line); t2 != null && t2.isPaintable(); t2 = t2.getNextToken()) {
                    Fold parentFold;
                    if (t2.isLeftCurly()) {
                        if (currentFold == null) {
                            currentFold = new Fold(0, textArea, t2.getOffset());
                            folds.add(currentFold);
                        } else {
                            currentFold = currentFold.createChild(0, t2.getOffset());
                        }
                        blocks.push(OBJECT_BLOCK);
                        continue;
                    }
                    if (t2.isRightCurly() && JsonFoldParser.popOffTop(blocks, OBJECT_BLOCK)) {
                        if (currentFold == null) continue;
                        currentFold.setEndOffset(t2.getOffset());
                        parentFold = currentFold.getParent();
                        if (currentFold.isOnSingleLine() && !currentFold.removeFromParent()) {
                            folds.remove(folds.size() - 1);
                        }
                        currentFold = parentFold;
                        continue;
                    }
                    if (JsonFoldParser.isLeftBracket(t2)) {
                        if (currentFold == null) {
                            currentFold = new Fold(0, textArea, t2.getOffset());
                            folds.add(currentFold);
                        } else {
                            currentFold = currentFold.createChild(0, t2.getOffset());
                        }
                        blocks.push(ARRAY_BLOCK);
                        continue;
                    }
                    if (!JsonFoldParser.isRightBracket(t2) || !JsonFoldParser.popOffTop(blocks, ARRAY_BLOCK) || currentFold == null) continue;
                    currentFold.setEndOffset(t2.getOffset());
                    parentFold = currentFold.getParent();
                    if (currentFold.isOnSingleLine() && !currentFold.removeFromParent()) {
                        folds.remove(folds.size() - 1);
                    }
                    currentFold = parentFold;
                }
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return folds;
    }

    private static boolean isLeftBracket(Token t2) {
        return t2.getType() == 22 && t2.isSingleChar('[');
    }

    private static boolean isRightBracket(Token t2) {
        return t2.getType() == 22 && t2.isSingleChar(']');
    }

    private static boolean popOffTop(Stack<Object> stack, Object value) {
        if (stack.size() > 0 && stack.peek() == value) {
            stack.pop();
            return true;
        }
        return false;
    }
}

