/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenUtils;

public final class HtmlUtil {
    private HtmlUtil() {
    }

    public static String escapeForHtml(String s2, String newlineReplacement, boolean inPreBlock) {
        if (newlineReplacement == null) {
            newlineReplacement = "";
        }
        String tabString = inPreBlock ? "    " : "&nbsp;&nbsp;&nbsp;&nbsp;";
        StringBuilder sb = new StringBuilder();
        block8: for (int i2 = 0; i2 < s2.length(); ++i2) {
            char ch2 = s2.charAt(i2);
            switch (ch2) {
                case ' ': {
                    if (inPreBlock) {
                        sb.append(' ');
                        continue block8;
                    }
                    sb.append("&nbsp;");
                    continue block8;
                }
                case '\n': {
                    sb.append(newlineReplacement);
                    continue block8;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block8;
                }
                case '\t': {
                    sb.append(tabString);
                    continue block8;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block8;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block8;
                }
                default: {
                    sb.append(ch2);
                }
            }
        }
        return sb.toString();
    }

    public static String getHexString(Color c2) {
        if (c2 == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("#");
        int r2 = c2.getRed();
        if (r2 < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(r2));
        int g2 = c2.getGreen();
        if (g2 < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(g2));
        int b2 = c2.getBlue();
        if (b2 < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(b2));
        return sb.toString();
    }

    public static String getTextAsHtml(RSyntaxTextArea textArea, int start, int end) {
        Token token;
        StringBuilder sb = new StringBuilder("<pre style='").append("font-family: \"").append(textArea.getFont().getFamily()).append("\", courier;");
        if (textArea.getBackground() != null) {
            sb.append(" background: ").append(HtmlUtil.getHexString(textArea.getBackground())).append("'>");
        }
        for (Token t2 = token = textArea.getTokenListFor(start, end); t2 != null; t2 = t2.getNextToken()) {
            if (!t2.isPaintable()) continue;
            if (t2.isSingleChar('\n')) {
                sb.append("<br>");
                continue;
            }
            sb.append(TokenUtils.tokenToHtml(textArea, t2));
        }
        sb.append("</pre>");
        return sb.toString();
    }
}

