/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaUI;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenPainter;

class DefaultTokenPainter
implements TokenPainter {
    private Rectangle2D.Float bgRect = new Rectangle2D.Float();
    private static char[] tabBuf;

    DefaultTokenPainter() {
    }

    @Override
    public final float paint(Token token, Graphics2D g2, float x2, float y2, RSyntaxTextArea host, TabExpander e2) {
        return this.paint(token, g2, x2, y2, host, e2, 0.0f);
    }

    @Override
    public float paint(Token token, Graphics2D g2, float x2, float y2, RSyntaxTextArea host, TabExpander e2, float clipStart) {
        return this.paintImpl(token, g2, x2, y2, host, e2, clipStart, false, false);
    }

    @Override
    public float paint(Token token, Graphics2D g2, float x2, float y2, RSyntaxTextArea host, TabExpander e2, float clipStart, boolean paintBG) {
        return this.paintImpl(token, g2, x2, y2, host, e2, clipStart, !paintBG, false);
    }

    protected void paintBackground(float x2, float y2, float width, float height, Graphics2D g2, int fontAscent, RSyntaxTextArea host, Color color) {
        g2.setColor(color);
        this.bgRect.setRect(x2, y2 - (float)fontAscent, width, height);
        g2.fillRect((int)x2, (int)(y2 - (float)fontAscent), (int)width, (int)height);
    }

    protected float paintImpl(Token token, Graphics2D g2, float x2, float y2, RSyntaxTextArea host, TabExpander e2, float clipStart, boolean selected, boolean useSTC) {
        int origX = (int)x2;
        int textOffs = token.getTextOffset();
        char[] text = token.getTextArray();
        int end = textOffs + token.length();
        float nextX = x2;
        int flushLen = 0;
        int flushIndex = textOffs;
        Color fg2 = useSTC ? host.getSelectedTextColor() : host.getForegroundForToken(token);
        Color bg2 = selected ? null : host.getBackgroundForToken(token);
        g2.setFont(host.getFontForTokenType(token.getType()));
        FontMetrics fm2 = host.getFontMetricsForTokenType(token.getType());
        block3: for (int i2 = textOffs; i2 < end; ++i2) {
            switch (text[i2]) {
                case '\t': {
                    nextX = e2.nextTabStop(x2 + (float)fm2.charsWidth(text, flushIndex, flushLen), 0);
                    if (bg2 != null) {
                        this.paintBackground(x2, y2, nextX - x2, fm2.getHeight(), g2, fm2.getAscent(), host, bg2);
                    }
                    if (flushLen > 0) {
                        g2.setColor(fg2);
                        g2.drawChars(text, flushIndex, flushLen, (int)x2, (int)y2);
                        flushLen = 0;
                    }
                    flushIndex = i2 + 1;
                    x2 = nextX;
                    continue block3;
                }
                default: {
                    ++flushLen;
                }
            }
        }
        nextX = x2 + (float)fm2.charsWidth(text, flushIndex, flushLen);
        Rectangle r2 = host.getMatchRectangle();
        if (flushLen > 0 && nextX >= clipStart) {
            if (bg2 != null) {
                this.paintBackground(x2, y2, nextX - x2, fm2.getHeight(), g2, fm2.getAscent(), host, bg2);
                if (token.length() == 1 && r2 != null && (float)r2.x == x2) {
                    ((RSyntaxTextAreaUI)host.getUI()).paintMatchedBracketImpl(g2, host, r2);
                }
            }
            g2.setColor(fg2);
            g2.drawChars(text, flushIndex, flushLen, (int)x2, (int)y2);
        }
        if (host.getUnderlineForToken(token)) {
            g2.setColor(fg2);
            int y22 = (int)(y2 + 1.0f);
            g2.drawLine(origX, y22, (int)nextX, y22);
        }
        if (host.getPaintTabLines() && origX == host.getMargin().left) {
            this.paintTabLines(token, origX, (int)y2, (int)nextX, g2, e2, host);
        }
        return nextX;
    }

    @Override
    public float paintSelected(Token token, Graphics2D g2, float x2, float y2, RSyntaxTextArea host, TabExpander e2, boolean useSTC) {
        return this.paintSelected(token, g2, x2, y2, host, e2, 0.0f, useSTC);
    }

    @Override
    public float paintSelected(Token token, Graphics2D g2, float x2, float y2, RSyntaxTextArea host, TabExpander e2, float clipStart, boolean useSTC) {
        return this.paintImpl(token, g2, x2, y2, host, e2, clipStart, true, useSTC);
    }

    protected void paintTabLines(Token token, int x2, int y2, int endX, Graphics2D g2, TabExpander e2, RSyntaxTextArea host) {
        Token next;
        if (token.getType() != 21) {
            int offs;
            for (offs = 0; offs < token.length() && RSyntaxUtilities.isWhitespace(token.charAt(offs)); ++offs) {
            }
            if (offs < 2) {
                return;
            }
            endX = (int)token.getWidthUpTo(offs, host, e2, 0.0f);
        }
        FontMetrics fm2 = host.getFontMetricsForTokenType(token.getType());
        int tabSize = host.getTabSize();
        if (tabBuf == null || tabBuf.length < tabSize) {
            tabBuf = new char[tabSize];
            for (int i2 = 0; i2 < tabSize; ++i2) {
                DefaultTokenPainter.tabBuf[i2] = 32;
            }
        }
        int tabW = fm2.charsWidth(tabBuf, 0, tabSize);
        g2.setColor(host.getTabLineColor());
        int x0 = x2 + tabW;
        int y0 = y2 - fm2.getAscent();
        if ((y0 & 1) > 0) {
            ++y0;
        }
        if ((next = token.getNextToken()) == null || !next.isPaintable()) {
            ++endX;
        }
        while (x0 < endX) {
            int y22 = y0 + host.getLineHeight();
            for (int y1 = y0; y1 < y22; y1 += 2) {
                g2.drawLine(x0, y1, x0, y1);
            }
            x0 += tabW;
        }
    }
}

