/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.AutoCompletionStyleContext;
import org.fife.ui.autocomplete.OutlineHighlightPainter;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionChoicesWindow;
import org.fife.ui.autocomplete.ParameterizedCompletionDescriptionToolTip;
import org.fife.ui.autocomplete.ParameterizedCompletionInsertionInfo;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;

class ParameterizedCompletionContext {
    private Window parentWindow;
    private AutoCompletion ac;
    private ParameterizedCompletion pc;
    private boolean active;
    private ParameterizedCompletionDescriptionToolTip tip;
    private Highlighter.HighlightPainter p;
    private Highlighter.HighlightPainter endingP;
    private Highlighter.HighlightPainter paramCopyP;
    private List<Object> tags;
    private List<ParamCopyInfo> paramCopyInfos;
    private transient boolean ignoringDocumentEvents;
    private Listener listener;
    private int minPos;
    private Position maxPos;
    private Position defaultEndOffs;
    private int lastSelectedParam;
    private ParameterizedCompletionChoicesWindow paramChoicesWindow;
    private String paramPrefix;
    private Object oldTabKey;
    private Action oldTabAction;
    private Object oldShiftTabKey;
    private Action oldShiftTabAction;
    private Object oldUpKey;
    private Action oldUpAction;
    private Object oldDownKey;
    private Action oldDownAction;
    private Object oldEnterKey;
    private Action oldEnterAction;
    private Object oldEscapeKey;
    private Action oldEscapeAction;
    private Object oldClosingKey;
    private Action oldClosingAction;
    private static final String IM_KEY_TAB = "ParamCompKey.Tab";
    private static final String IM_KEY_SHIFT_TAB = "ParamCompKey.ShiftTab";
    private static final String IM_KEY_UP = "ParamCompKey.Up";
    private static final String IM_KEY_DOWN = "ParamCompKey.Down";
    private static final String IM_KEY_ESCAPE = "ParamCompKey.Escape";
    private static final String IM_KEY_ENTER = "ParamCompKey.Enter";
    private static final String IM_KEY_CLOSING = "ParamCompKey.Closing";

    ParameterizedCompletionContext(Window owner, AutoCompletion ac2, ParameterizedCompletion pc) {
        this.parentWindow = owner;
        this.ac = ac2;
        this.pc = pc;
        this.listener = new Listener();
        AutoCompletionStyleContext sc = AutoCompletion.getStyleContext();
        this.p = new OutlineHighlightPainter(sc.getParameterOutlineColor());
        this.endingP = new OutlineHighlightPainter(sc.getParameterizedCompletionCursorPositionColor());
        this.paramCopyP = new ChangeableHighlightPainter(sc.getParameterCopyColor());
        this.tags = new ArrayList<Object>(1);
        this.paramCopyInfos = new ArrayList<ParamCopyInfo>(1);
    }

    public void activate() {
        if (this.active) {
            return;
        }
        this.active = true;
        JTextComponent tc = this.ac.getTextComponent();
        this.lastSelectedParam = -1;
        if (this.pc.getShowParameterToolTip()) {
            this.tip = new ParameterizedCompletionDescriptionToolTip(this.parentWindow, this, this.ac, this.pc);
            try {
                int dot = tc.getCaretPosition();
                Rectangle r2 = tc.modelToView(dot);
                Point p2 = new Point(r2.x, r2.y);
                SwingUtilities.convertPointToScreen(p2, tc);
                r2.x = p2.x;
                r2.y = p2.y;
                this.tip.setLocationRelativeTo(r2);
                this.tip.setVisible(true);
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback(tc);
                ble.printStackTrace();
                this.tip = null;
            }
        }
        this.listener.install(tc);
        if (this.paramChoicesWindow == null) {
            this.paramChoicesWindow = this.createParamChoicesWindow();
        }
        this.lastSelectedParam = this.getCurrentParameterIndex();
        this.prepareParamChoicesWindow();
        this.paramChoicesWindow.setVisible(true);
    }

    private ParameterizedCompletionChoicesWindow createParamChoicesWindow() {
        ParameterizedCompletionChoicesWindow pcw = new ParameterizedCompletionChoicesWindow(this.parentWindow, this.ac, this);
        pcw.initialize(this.pc);
        return pcw;
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.listener.uninstall();
        if (this.tip != null) {
            this.tip.setVisible(false);
        }
        if (this.paramChoicesWindow != null) {
            this.paramChoicesWindow.setVisible(false);
        }
    }

    public String getArgumentText(int offs) {
        List<Highlighter.Highlight> paramHighlights = this.getParameterHighlights();
        if (paramHighlights == null || paramHighlights.size() == 0) {
            return null;
        }
        for (Highlighter.Highlight h2 : paramHighlights) {
            if (offs < h2.getStartOffset() || offs > h2.getEndOffset()) continue;
            int start = h2.getStartOffset() + 1;
            int len = h2.getEndOffset() - start;
            JTextComponent tc = this.ac.getTextComponent();
            Document doc = tc.getDocument();
            try {
                return doc.getText(start, len);
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback(tc);
                ble.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private Highlighter.Highlight getCurrentParameterHighlight() {
        JTextComponent tc = this.ac.getTextComponent();
        int dot = tc.getCaretPosition();
        if (dot > 0) {
            --dot;
        }
        List<Highlighter.Highlight> paramHighlights = this.getParameterHighlights();
        for (Highlighter.Highlight h2 : paramHighlights) {
            if (dot < h2.getStartOffset() || dot >= h2.getEndOffset()) continue;
            return h2;
        }
        return null;
    }

    private int getCurrentParameterIndex() {
        JTextComponent tc = this.ac.getTextComponent();
        int dot = tc.getCaretPosition();
        if (dot > 0) {
            --dot;
        }
        List<Highlighter.Highlight> paramHighlights = this.getParameterHighlights();
        for (int i2 = 0; i2 < paramHighlights.size(); ++i2) {
            Highlighter.Highlight h2 = paramHighlights.get(i2);
            if (dot < h2.getStartOffset() || dot >= h2.getEndOffset()) continue;
            return i2;
        }
        return -1;
    }

    private int getCurrentParameterStartOffset() {
        Highlighter.Highlight h2 = this.getCurrentParameterHighlight();
        return h2 != null ? h2.getStartOffset() + 1 : -1;
    }

    private static int getFirstHighlight(List<Highlighter.Highlight> highlights) {
        int first = -1;
        Highlighter.Highlight firstH = null;
        for (int i2 = 0; i2 < highlights.size(); ++i2) {
            Highlighter.Highlight h2 = highlights.get(i2);
            if (firstH != null && h2.getStartOffset() >= firstH.getStartOffset()) continue;
            firstH = h2;
            first = i2;
        }
        return first;
    }

    private static int getLastHighlight(List<Highlighter.Highlight> highlights) {
        int last = -1;
        Highlighter.Highlight lastH = null;
        for (int i2 = highlights.size() - 1; i2 >= 0; --i2) {
            Highlighter.Highlight h2 = highlights.get(i2);
            if (lastH != null && h2.getStartOffset() <= lastH.getStartOffset()) continue;
            lastH = h2;
            last = i2;
        }
        return last;
    }

    public List<Highlighter.Highlight> getParameterHighlights() {
        Highlighter.Highlight[] highlights;
        ArrayList<Highlighter.Highlight> paramHighlights = new ArrayList<Highlighter.Highlight>(2);
        JTextComponent tc = this.ac.getTextComponent();
        for (Highlighter.Highlight highlight : highlights = tc.getHighlighter().getHighlights()) {
            Highlighter.HighlightPainter painter = highlight.getPainter();
            if (painter != this.p && painter != this.endingP) continue;
            paramHighlights.add(highlight);
        }
        return paramHighlights;
    }

    boolean insertSelectedChoice() {
        String choice;
        if (this.paramChoicesWindow != null && this.paramChoicesWindow.isVisible() && (choice = this.paramChoicesWindow.getSelectedChoice()) != null) {
            JTextComponent tc = this.ac.getTextComponent();
            Highlighter.Highlight h2 = this.getCurrentParameterHighlight();
            if (h2 != null) {
                tc.setSelectionStart(h2.getStartOffset() + 1);
                tc.setSelectionEnd(h2.getEndOffset());
                tc.replaceSelection(choice);
                this.moveToNextParam();
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(tc);
            }
            return true;
        }
        return false;
    }

    private void installKeyBindings() {
        if (AutoCompletion.getDebug()) {
            System.out.println("CompletionContext: Installing keybindings");
        }
        JTextComponent tc = this.ac.getTextComponent();
        InputMap im2 = tc.getInputMap();
        ActionMap am2 = tc.getActionMap();
        KeyStroke ks = KeyStroke.getKeyStroke(9, 0);
        this.oldTabKey = im2.get(ks);
        im2.put(ks, IM_KEY_TAB);
        this.oldTabAction = am2.get(IM_KEY_TAB);
        am2.put(IM_KEY_TAB, new NextParamAction());
        ks = KeyStroke.getKeyStroke(9, 1);
        this.oldShiftTabKey = im2.get(ks);
        im2.put(ks, IM_KEY_SHIFT_TAB);
        this.oldShiftTabAction = am2.get(IM_KEY_SHIFT_TAB);
        am2.put(IM_KEY_SHIFT_TAB, new PrevParamAction());
        ks = KeyStroke.getKeyStroke(38, 0);
        this.oldUpKey = im2.get(ks);
        im2.put(ks, IM_KEY_UP);
        this.oldUpAction = am2.get(IM_KEY_UP);
        am2.put(IM_KEY_UP, new NextChoiceAction(-1, this.oldUpAction));
        ks = KeyStroke.getKeyStroke(40, 0);
        this.oldDownKey = im2.get(ks);
        im2.put(ks, IM_KEY_DOWN);
        this.oldDownAction = am2.get(IM_KEY_DOWN);
        am2.put(IM_KEY_DOWN, new NextChoiceAction(1, this.oldDownAction));
        ks = KeyStroke.getKeyStroke(10, 0);
        this.oldEnterKey = im2.get(ks);
        im2.put(ks, IM_KEY_ENTER);
        this.oldEnterAction = am2.get(IM_KEY_ENTER);
        am2.put(IM_KEY_ENTER, new GotoEndAction());
        ks = KeyStroke.getKeyStroke(27, 0);
        this.oldEscapeKey = im2.get(ks);
        im2.put(ks, IM_KEY_ESCAPE);
        this.oldEscapeAction = am2.get(IM_KEY_ESCAPE);
        am2.put(IM_KEY_ESCAPE, new HideAction());
        char end = this.pc.getProvider().getParameterListEnd();
        ks = KeyStroke.getKeyStroke(end);
        this.oldClosingKey = im2.get(ks);
        im2.put(ks, IM_KEY_CLOSING);
        this.oldClosingAction = am2.get(IM_KEY_CLOSING);
        am2.put(IM_KEY_CLOSING, new ClosingAction());
    }

    private void moveToNextParam() {
        JTextComponent tc = this.ac.getTextComponent();
        int dot = tc.getCaretPosition();
        int tagCount = this.tags.size();
        if (tagCount == 0) {
            tc.setCaretPosition(this.maxPos.getOffset());
            this.deactivate();
        }
        Highlighter.Highlight currentNext = null;
        int pos = -1;
        List<Highlighter.Highlight> highlights = this.getParameterHighlights();
        for (int i2 = 0; i2 < highlights.size(); ++i2) {
            Highlighter.Highlight hl2 = highlights.get(i2);
            if (currentNext != null && currentNext.getStartOffset() >= dot && (hl2.getStartOffset() <= dot || hl2.getStartOffset() > currentNext.getStartOffset())) continue;
            currentNext = hl2;
            pos = i2;
        }
        if (currentNext.getStartOffset() + 1 <= dot) {
            int nextIndex = ParameterizedCompletionContext.getFirstHighlight(highlights);
            currentNext = highlights.get(nextIndex);
            pos = 0;
        }
        tc.setSelectionStart(currentNext.getStartOffset() + 1);
        tc.setSelectionEnd(currentNext.getEndOffset());
        this.updateToolTipText(pos);
    }

    private void moveToPreviousParam() {
        JTextComponent tc = this.ac.getTextComponent();
        int tagCount = this.tags.size();
        if (tagCount == 0) {
            tc.setCaretPosition(this.maxPos.getOffset());
            this.deactivate();
        }
        int dot = tc.getCaretPosition();
        int selStart = tc.getSelectionStart() - 1;
        Highlighter.Highlight currentPrev = null;
        int pos = 0;
        List<Highlighter.Highlight> highlights = this.getParameterHighlights();
        for (int i2 = 0; i2 < highlights.size(); ++i2) {
            Highlighter.Highlight h2 = highlights.get(i2);
            if (currentPrev != null && currentPrev.getStartOffset() < dot && (h2.getStartOffset() >= selStart || h2.getStartOffset() <= currentPrev.getStartOffset() && pos != this.lastSelectedParam)) continue;
            currentPrev = h2;
            pos = i2;
        }
        int firstIndex = ParameterizedCompletionContext.getFirstHighlight(highlights);
        if (pos == firstIndex && this.lastSelectedParam == firstIndex && highlights.size() > 1) {
            pos = ParameterizedCompletionContext.getLastHighlight(highlights);
            currentPrev = highlights.get(pos);
            tc.setSelectionStart(currentPrev.getStartOffset() + 1);
            tc.setSelectionEnd(currentPrev.getEndOffset());
            this.updateToolTipText(pos);
        } else if (currentPrev != null && dot > currentPrev.getStartOffset()) {
            tc.setSelectionStart(currentPrev.getStartOffset() + 1);
            tc.setSelectionEnd(currentPrev.getEndOffset());
            this.updateToolTipText(pos);
        } else {
            tc.setCaretPosition(this.maxPos.getOffset());
            this.deactivate();
        }
    }

    private void possiblyUpdateParamCopies(Document doc) {
        int index = this.getCurrentParameterIndex();
        if (index > -1 && index < this.pc.getParamCount()) {
            ParameterizedCompletion.Parameter param = this.pc.getParam(index);
            if (param.isEndParam()) {
                this.deactivate();
                return;
            }
            List<Highlighter.Highlight> paramHighlights = this.getParameterHighlights();
            Highlighter.Highlight h2 = paramHighlights.get(index);
            int start = h2.getStartOffset() + 1;
            int len = h2.getEndOffset() - start;
            String replacement = null;
            try {
                replacement = doc.getText(start, len);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            for (ParamCopyInfo pci : this.paramCopyInfos) {
                if (!pci.paramName.equals(param.getName())) continue;
                pci.h = this.replaceHighlightedText(doc, pci.h, replacement);
            }
        } else {
            this.deactivate();
        }
    }

    private void prepareParamChoicesWindow() {
        if (this.paramChoicesWindow != null) {
            int offs = this.getCurrentParameterStartOffset();
            if (offs == -1) {
                this.paramChoicesWindow.setVisible(false);
                return;
            }
            JTextComponent tc = this.ac.getTextComponent();
            try {
                Rectangle r2 = tc.modelToView(offs);
                Point p2 = new Point(r2.x, r2.y);
                SwingUtilities.convertPointToScreen(p2, tc);
                r2.x = p2.x;
                r2.y = p2.y;
                this.paramChoicesWindow.setLocationRelativeTo(r2);
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback(tc);
                ble.printStackTrace();
            }
            this.paramChoicesWindow.setParameter(this.lastSelectedParam, this.paramPrefix);
        }
    }

    private void removeParameterHighlights() {
        JTextComponent tc = this.ac.getTextComponent();
        Highlighter h2 = tc.getHighlighter();
        for (Object tag : this.tags) {
            h2.removeHighlight(tag);
        }
        this.tags.clear();
        for (ParamCopyInfo pci : this.paramCopyInfos) {
            h2.removeHighlight(pci.h);
        }
        this.paramCopyInfos.clear();
    }

    private Highlighter.Highlight replaceHighlightedText(Document doc, Highlighter.Highlight h2, String replacement) {
        try {
            int start = h2.getStartOffset();
            int len = h2.getEndOffset() - start;
            Highlighter highlighter = this.ac.getTextComponent().getHighlighter();
            highlighter.removeHighlight(h2);
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).replace(start, len, replacement, null);
            } else {
                doc.remove(start, len);
                doc.insertString(start, replacement, null);
            }
            int newEnd = start + replacement.length();
            h2 = (Highlighter.Highlight)highlighter.addHighlight(start, newEnd, this.paramCopyP);
            return h2;
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return null;
        }
    }

    private void uninstallKeyBindings() {
        if (AutoCompletion.getDebug()) {
            System.out.println("CompletionContext Uninstalling keybindings");
        }
        JTextComponent tc = this.ac.getTextComponent();
        InputMap im2 = tc.getInputMap();
        ActionMap am2 = tc.getActionMap();
        KeyStroke ks = KeyStroke.getKeyStroke(9, 0);
        im2.put(ks, this.oldTabKey);
        am2.put(IM_KEY_TAB, this.oldTabAction);
        ks = KeyStroke.getKeyStroke(9, 1);
        im2.put(ks, this.oldShiftTabKey);
        am2.put(IM_KEY_SHIFT_TAB, this.oldShiftTabAction);
        ks = KeyStroke.getKeyStroke(38, 0);
        im2.put(ks, this.oldUpKey);
        am2.put(IM_KEY_UP, this.oldUpAction);
        ks = KeyStroke.getKeyStroke(40, 0);
        im2.put(ks, this.oldDownKey);
        am2.put(IM_KEY_DOWN, this.oldDownAction);
        ks = KeyStroke.getKeyStroke(10, 0);
        im2.put(ks, this.oldEnterKey);
        am2.put(IM_KEY_ENTER, this.oldEnterAction);
        ks = KeyStroke.getKeyStroke(27, 0);
        im2.put(ks, this.oldEscapeKey);
        am2.put(IM_KEY_ESCAPE, this.oldEscapeAction);
        char end = this.pc.getProvider().getParameterListEnd();
        ks = KeyStroke.getKeyStroke(end);
        im2.put(ks, this.oldClosingKey);
        am2.put(IM_KEY_CLOSING, this.oldClosingAction);
    }

    private String updateToolTipText() {
        JTextComponent tc = this.ac.getTextComponent();
        int dot = tc.getSelectionStart();
        int mark = tc.getSelectionEnd();
        int index = -1;
        String paramPrefix = null;
        List<Highlighter.Highlight> paramHighlights = this.getParameterHighlights();
        for (int i2 = 0; i2 < paramHighlights.size(); ++i2) {
            Highlighter.Highlight h2 = paramHighlights.get(i2);
            int start = h2.getStartOffset() + 1;
            if (dot < start || dot > h2.getEndOffset()) continue;
            try {
                if (dot != start || mark != h2.getEndOffset()) {
                    paramPrefix = tc.getText(start, dot - start);
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            index = i2;
            break;
        }
        this.updateToolTipText(index);
        return paramPrefix;
    }

    private void updateToolTipText(int selectedParam) {
        if (selectedParam != this.lastSelectedParam) {
            if (this.tip != null) {
                this.tip.updateText(selectedParam);
            }
            this.lastSelectedParam = selectedParam;
        }
    }

    public void updateUI() {
        if (this.tip != null) {
            this.tip.updateUI();
        }
        if (this.paramChoicesWindow != null) {
            this.paramChoicesWindow.updateUI();
        }
    }

    private class PrevParamAction
    extends AbstractAction {
        private PrevParamAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            ParameterizedCompletionContext.this.moveToPreviousParam();
        }
    }

    private static class ParamCopyInfo {
        private String paramName;
        private Highlighter.Highlight h;

        ParamCopyInfo(String paramName, Highlighter.Highlight h2) {
            this.paramName = paramName;
            this.h = h2;
        }
    }

    private class NextParamAction
    extends AbstractAction {
        private NextParamAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            ParameterizedCompletionContext.this.moveToNextParam();
        }
    }

    private class NextChoiceAction
    extends AbstractAction {
        private Action oldAction;
        private int amount;

        NextChoiceAction(int amount, Action oldAction) {
            this.amount = amount;
            this.oldAction = oldAction;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (ParameterizedCompletionContext.this.paramChoicesWindow != null && ParameterizedCompletionContext.this.paramChoicesWindow.isVisible()) {
                ParameterizedCompletionContext.this.paramChoicesWindow.incSelection(this.amount);
            } else if (this.oldAction != null) {
                this.oldAction.actionPerformed(e2);
            } else {
                ParameterizedCompletionContext.this.deactivate();
            }
        }
    }

    private class Listener
    implements FocusListener,
    CaretListener,
    DocumentListener {
        private boolean markOccurrencesEnabled;

        private Listener() {
        }

        @Override
        public void caretUpdate(CaretEvent e2) {
            if (ParameterizedCompletionContext.this.maxPos == null) {
                ParameterizedCompletionContext.this.deactivate();
                return;
            }
            int dot = e2.getDot();
            if (dot < ParameterizedCompletionContext.this.minPos || dot > ParameterizedCompletionContext.this.maxPos.getOffset()) {
                ParameterizedCompletionContext.this.deactivate();
                return;
            }
            ParameterizedCompletionContext.this.paramPrefix = ParameterizedCompletionContext.this.updateToolTipText();
            if (ParameterizedCompletionContext.this.active) {
                ParameterizedCompletionContext.this.prepareParamChoicesWindow();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e2) {
        }

        @Override
        public void focusGained(FocusEvent e2) {
        }

        @Override
        public void focusLost(FocusEvent e2) {
            ParameterizedCompletionContext.this.deactivate();
        }

        private void handleDocumentEvent(DocumentEvent e2) {
            if (!ParameterizedCompletionContext.this.ignoringDocumentEvents) {
                ParameterizedCompletionContext.this.ignoringDocumentEvents = true;
                SwingUtilities.invokeLater(() -> {
                    ParameterizedCompletionContext.this.possiblyUpdateParamCopies(e2.getDocument());
                    ParameterizedCompletionContext.this.ignoringDocumentEvents = false;
                });
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e2) {
            this.handleDocumentEvent(e2);
        }

        public void install(JTextComponent tc) {
            boolean replaceTabs = false;
            if (tc instanceof RSyntaxTextArea) {
                RSyntaxTextArea textArea = (RSyntaxTextArea)tc;
                this.markOccurrencesEnabled = textArea.getMarkOccurrences();
                textArea.setMarkOccurrences(false);
                replaceTabs = textArea.getTabsEmulated();
            }
            Highlighter h2 = tc.getHighlighter();
            try {
                int i2;
                ParameterizedCompletionInsertionInfo info = ParameterizedCompletionContext.this.pc.getInsertionInfo(tc, replaceTabs);
                tc.replaceSelection(info.getTextToInsert());
                int replacementCount = info.getReplacementCount();
                for (i2 = 0; i2 < replacementCount; ++i2) {
                    DocumentRange dr2 = info.getReplacementLocation(i2);
                    Highlighter.HighlightPainter painter = i2 < replacementCount - 1 ? ParameterizedCompletionContext.this.p : ParameterizedCompletionContext.this.endingP;
                    ParameterizedCompletionContext.this.tags.add(h2.addHighlight(dr2.getStartOffset() - 1, dr2.getEndOffset(), painter));
                }
                for (i2 = 0; i2 < info.getReplacementCopyCount(); ++i2) {
                    ParameterizedCompletionInsertionInfo.ReplacementCopy rc = info.getReplacementCopy(i2);
                    ParameterizedCompletionContext.this.paramCopyInfos.add(new ParamCopyInfo(rc.getId(), (Highlighter.Highlight)h2.addHighlight(rc.getStart(), rc.getEnd(), ParameterizedCompletionContext.this.paramCopyP)));
                }
                tc.setCaretPosition(info.getSelectionStart());
                if (info.hasSelection()) {
                    tc.moveCaretPosition(info.getSelectionEnd());
                }
                ParameterizedCompletionContext.this.minPos = info.getMinOffset();
                ParameterizedCompletionContext.this.maxPos = info.getMaxOffset();
                try {
                    Document doc = tc.getDocument();
                    if (ParameterizedCompletionContext.this.maxPos.getOffset() == 0) {
                        ParameterizedCompletionContext.this.maxPos = doc.createPosition(info.getTextToInsert().length());
                    }
                    ParameterizedCompletionContext.this.defaultEndOffs = doc.createPosition(info.getDefaultEndOffs());
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
                tc.getDocument().addDocumentListener(this);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            tc.addCaretListener(this);
            tc.addFocusListener(this);
            ParameterizedCompletionContext.this.installKeyBindings();
        }

        @Override
        public void removeUpdate(DocumentEvent e2) {
            this.handleDocumentEvent(e2);
        }

        public void uninstall() {
            JTextComponent tc = ParameterizedCompletionContext.this.ac.getTextComponent();
            tc.removeCaretListener(this);
            tc.removeFocusListener(this);
            tc.getDocument().removeDocumentListener(this);
            ParameterizedCompletionContext.this.uninstallKeyBindings();
            if (this.markOccurrencesEnabled) {
                ((RSyntaxTextArea)tc).setMarkOccurrences(this.markOccurrencesEnabled);
            }
            ParameterizedCompletionContext.this.maxPos = null;
            ParameterizedCompletionContext.this.minPos = -1;
            ParameterizedCompletionContext.this.removeParameterHighlights();
        }
    }

    private class HideAction
    extends AbstractAction {
        private HideAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (ParameterizedCompletionContext.this.paramChoicesWindow != null && ParameterizedCompletionContext.this.paramChoicesWindow.isVisible()) {
                ParameterizedCompletionContext.this.paramChoicesWindow.setVisible(false);
                ParameterizedCompletionContext.this.paramChoicesWindow = null;
            } else {
                ParameterizedCompletionContext.this.deactivate();
            }
        }
    }

    private class ClosingAction
    extends AbstractAction {
        private ClosingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            JTextComponent tc = ParameterizedCompletionContext.this.ac.getTextComponent();
            int dot = tc.getCaretPosition();
            char end = ParameterizedCompletionContext.this.pc.getProvider().getParameterListEnd();
            if (dot >= ParameterizedCompletionContext.this.maxPos.getOffset() - 2) {
                int endCount;
                char start;
                int startCount;
                String text = ParameterizedCompletionContext.this.getArgumentText(dot);
                if (text != null && (startCount = this.getCount(text, start = ParameterizedCompletionContext.this.pc.getProvider().getParameterListStart())) > (endCount = this.getCount(text, end))) {
                    tc.replaceSelection(Character.toString(end));
                    return;
                }
                tc.setCaretPosition(Math.min(tc.getCaretPosition() + 1, tc.getDocument().getLength()));
                ParameterizedCompletionContext.this.deactivate();
            } else {
                tc.replaceSelection(Character.toString(end));
            }
        }

        public int getCount(String text, char ch2) {
            int pos;
            int count = 0;
            int old = 0;
            while ((pos = text.indexOf(ch2, old)) > -1) {
                ++count;
                old = pos + 1;
            }
            return count;
        }
    }

    private class GotoEndAction
    extends AbstractAction {
        private GotoEndAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (ParameterizedCompletionContext.this.paramChoicesWindow != null && ParameterizedCompletionContext.this.paramChoicesWindow.isVisible() && ParameterizedCompletionContext.this.insertSelectedChoice()) {
                return;
            }
            ParameterizedCompletionContext.this.deactivate();
            JTextComponent tc = ParameterizedCompletionContext.this.ac.getTextComponent();
            int dot = tc.getCaretPosition();
            if (dot != ParameterizedCompletionContext.this.defaultEndOffs.getOffset()) {
                tc.setCaretPosition(ParameterizedCompletionContext.this.defaultEndOffs.getOffset());
            } else {
                Action a2 = this.getDefaultEnterAction(tc);
                if (a2 != null) {
                    a2.actionPerformed(e2);
                } else {
                    tc.replaceSelection("\n");
                }
            }
        }

        private Action getDefaultEnterAction(JTextComponent tc) {
            ActionMap am2 = tc.getActionMap();
            return am2.get("insert-break");
        }
    }
}

