/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicListUI;

class FastListUI
extends BasicListUI {
    private boolean overriddenBackground;
    private boolean overriddenForeground;
    private static final int ESTIMATION_THRESHOLD = 200;

    FastListUI() {
    }

    private Color determineSelectionBackground() {
        Color c2 = UIManager.getColor("List.selectionBackground");
        if (c2 == null && (c2 = UIManager.getColor("nimbusSelectionBackground")) == null && (c2 = UIManager.getColor("textHighlight")) == null) {
            c2 = SystemColor.textHighlight;
        }
        return new Color(c2.getRGB());
    }

    private Color determineSelectionForeground() {
        Color c2 = UIManager.getColor("List.selectionForeground");
        if (c2 == null && (c2 = UIManager.getColor("nimbusSelectedText")) == null && (c2 = UIManager.getColor("textHighlightText")) == null) {
            c2 = SystemColor.textHighlightText;
        }
        return new Color(c2.getRGB());
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (this.list.getSelectionBackground() == null) {
            this.list.setSelectionBackground(this.determineSelectionBackground());
            this.overriddenBackground = true;
        }
        if (this.list.getSelectionForeground() == null) {
            this.list.setSelectionForeground(this.determineSelectionForeground());
            this.overriddenForeground = true;
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (this.overriddenBackground) {
            this.list.setSelectionBackground(null);
        }
        if (this.overriddenForeground) {
            this.list.setSelectionForeground(null);
        }
    }

    @Override
    protected void updateLayoutState() {
        ListModel model = this.list.getModel();
        int itemCount = model.getSize();
        if (itemCount < 200) {
            super.updateLayoutState();
            return;
        }
        ListCellRenderer renderer = this.list.getCellRenderer();
        this.cellWidth = this.list.getWidth();
        if (this.list.getParent() instanceof JViewport) {
            this.cellWidth = this.list.getParent().getWidth();
        }
        this.cellHeights = null;
        if (renderer != null) {
            Object value = model.getElementAt(0);
            Component c2 = renderer.getListCellRendererComponent(this.list, value, 0, false, false);
            this.rendererPane.add(c2);
            Dimension cellSize = c2.getPreferredSize();
            this.cellHeight = cellSize.height;
            this.cellWidth = Math.max(this.cellWidth, cellSize.width);
        } else {
            this.cellHeight = 20;
        }
    }
}

