/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.http.api.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.Instant;

public class InstantTypeAdapter
extends TypeAdapter<Instant> {
    @Override
    public void write(JsonWriter out, Instant value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.value(value.toEpochMilli());
    }

    @Override
    public Instant read(JsonReader in2) throws IOException {
        if (in2.peek() == JsonToken.NULL) {
            in2.nextNull();
            return null;
        }
        if (in2.peek() == JsonToken.NUMBER) {
            long jsTime = in2.nextLong();
            return Instant.ofEpochMilli(jsTime);
        }
        long seconds = 0L;
        int nanos = 0;
        in2.beginObject();
        while (in2.peek() != JsonToken.END_OBJECT) {
            switch (in2.nextName()) {
                case "nanos": {
                    nanos = in2.nextInt();
                    break;
                }
                case "seconds": {
                    seconds = in2.nextLong();
                }
            }
        }
        in2.endObject();
        return Instant.ofEpochSecond(seconds, nanos);
    }
}

