/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;

class ClientToolbarPanel
extends JPanel {
    private final TreeMap<NavigationButton, Component> entries = new TreeMap(NavigationButton.COMPARATOR);

    ClientToolbarPanel(boolean isInSidebar) {
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        if (isInSidebar) {
            this.setLayout(new DynamicGridLayout(0, 1, 0, 4));
        } else {
            this.setLayout(new DynamicGridLayout(1, 0, 4, 0));
        }
        this.revalidate();
    }

    JButton add(NavigationButton nb, boolean resize) {
        ImageIcon icon = new ImageIcon(resize ? ImageUtil.resizeImage(nb.getIcon(), 16, 16) : nb.getIcon());
        JButton jb2 = new JButton(icon);
        SwingUtil.removeButtonDecorations(jb2);
        jb2.setToolTipText(nb.getTooltip());
        jb2.setFocusable(false);
        jb2.setPreferredSize(new Dimension(23, 23));
        jb2.setAlignmentX(0.5f);
        jb2.setAlignmentY(0.5f);
        jb2.addActionListener(l2 -> {
            if (nb.getOnClick() != null) {
                nb.getOnClick().run();
            }
        });
        if (nb.getPopup() != null) {
            JPopupMenu menu = new JPopupMenu();
            nb.getPopup().forEach((name, cb2) -> {
                JMenuItem menuItem = new JMenuItem((String)name);
                menuItem.addActionListener(e2 -> cb2.run());
                menu.add(menuItem);
            });
            jb2.setComponentPopupMenu(menu);
        }
        if (this.entries.putIfAbsent(nb, jb2) != null) {
            return null;
        }
        this.add((Component)jb2, this.entries.headMap(nb).size());
        this.revalidate();
        this.revalidateMaxSize();
        return jb2;
    }

    void remove(NavigationButton btn) {
        Component c2 = this.entries.remove(btn);
        if (c2 != null) {
            this.remove(c2);
            this.revalidate();
            this.revalidateMaxSize();
        }
    }

    private void revalidateMaxSize() {
        this.setMaximumSize(this.getPreferredSize());
    }

    public JPanel createSidebarPanel() {
        JPanel wrap = new JPanel();
        wrap.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        wrap.setLayout(new BorderLayout());
        wrap.add((Component)this, "South");
        return wrap;
    }
}

