/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.kourendlibrary;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Singleton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.plugins.kourendlibrary.Book;
import net.runelite.client.plugins.kourendlibrary.BookPanel;
import net.runelite.client.plugins.kourendlibrary.Bookcase;
import net.runelite.client.plugins.kourendlibrary.KourendLibraryPlugin;
import net.runelite.client.plugins.kourendlibrary.Library;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;

@Singleton
class KourendLibraryPanel
extends PluginPanel {
    private static final ImageIcon RESET_ICON;
    private static final ImageIcon RESET_HOVER_ICON;
    private final KourendLibraryPlugin plugin;
    private final Library library;
    private final HashMap<Book, BookPanel> bookPanels = new HashMap();

    @Inject
    KourendLibraryPanel(KourendLibraryPlugin plugin, Library library) {
        this.plugin = plugin;
        this.library = library;
    }

    void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JPanel books = new JPanel(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 2;
        c2.weightx = 1.0;
        c2.gridx = 0;
        c2.gridy = 0;
        Stream.of(Book.values()).filter(b2 -> b2 != Book.VARLAMORE_ENVOY || this.plugin.showVarlamoreEnvoy()).sorted(Comparator.comparing(Book::getShortName)).forEach(b2 -> {
            BookPanel p2 = new BookPanel((Book)((Object)b2));
            this.bookPanels.put((Book)((Object)b2), p2);
            books.add((Component)p2, c2);
            ++c2.gridy;
        });
        JButton reset = new JButton("Reset", RESET_ICON);
        reset.setRolloverIcon(RESET_HOVER_ICON);
        reset.addActionListener(ev2 -> {
            this.library.reset();
            this.update();
        });
        this.add((Component)reset, "North");
        this.add((Component)books, "Center");
        this.update();
    }

    void update() {
        SwingUtilities.invokeLater(() -> {
            Book customerBook = this.library.getCustomerBook();
            for (Map.Entry<Book, BookPanel> b2 : this.bookPanels.entrySet()) {
                Book book = b2.getKey();
                BookPanel panel = b2.getValue();
                panel.setIsTarget(customerBook == book);
                panel.setIsHeld(this.plugin.doesPlayerContainBook(book));
            }
            HashMap<Book, HashSet> bookLocations = new HashMap<Book, HashSet>();
            for (Bookcase bookcase : this.library.getBookcases()) {
                if (bookcase.getBook() != null) {
                    bookLocations.computeIfAbsent(bookcase.getBook(), a2 -> new HashSet()).add(bookcase.getLocationString());
                    continue;
                }
                for (Book book : bookcase.getPossibleBooks()) {
                    if (book == null) continue;
                    bookLocations.computeIfAbsent(book, a2 -> new HashSet()).add(bookcase.getLocationString());
                }
            }
            for (Map.Entry entry : this.bookPanels.entrySet()) {
                HashSet locs = (HashSet)bookLocations.get(entry.getKey());
                if (locs == null || locs.size() > 3) {
                    ((BookPanel)entry.getValue()).setLocation("Unknown");
                    continue;
                }
                ((BookPanel)entry.getValue()).setLocation("<html>" + locs.stream().collect(Collectors.joining("<br>")) + "</html>");
            }
        });
    }

    void reload() {
        this.bookPanels.clear();
        this.removeAll();
        this.init();
    }

    static {
        BufferedImage resetIcon = ImageUtil.loadImageResource(KourendLibraryPanel.class, "/util/reset.png");
        RESET_ICON = new ImageIcon(resetIcon);
        RESET_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)resetIcon, -100));
    }
}

