/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.devtools;

import java.awt.Color;
import javax.swing.JButton;
import net.runelite.client.plugins.devtools.DevToolsFrame;
import net.runelite.client.ui.ColorScheme;

public class DevToolsButton
extends JButton {
    private boolean active;

    DevToolsButton(String title) {
        super(title);
        this.addActionListener(ev2 -> this.setActive(!this.active));
        this.setToolTipText(title);
    }

    void setActive(boolean active) {
        this.active = active;
        if (active) {
            this.setBackground(Color.GREEN);
        } else {
            this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        }
    }

    void addFrame(DevToolsFrame frame) {
        frame.setDevToolsButton(this);
        this.addActionListener(ev2 -> {
            if (this.isActive()) {
                frame.close();
            } else {
                frame.open();
            }
        });
    }

    public boolean isActive() {
        return this.active;
    }
}

