/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.game.chatbox;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.vars.InputType;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.chatbox.ChatboxInput;
import net.runelite.client.game.chatbox.ChatboxTextInput;
import net.runelite.client.game.chatbox.ChatboxTextMenuInput;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.input.MouseWheelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ChatboxPanelManager {
    private static final Logger log = LoggerFactory.getLogger(ChatboxPanelManager.class);
    private final Client client;
    private final ClientThread clientThread;
    private final EventBus eventBus;
    private final KeyManager keyManager;
    private final MouseManager mouseManager;
    private final Provider<ChatboxTextMenuInput> chatboxTextMenuInputProvider;
    private final Provider<ChatboxTextInput> chatboxTextInputProvider;
    private ChatboxInput currentInput = null;

    @Inject
    private ChatboxPanelManager(EventBus eventBus, Client client2, ClientThread clientThread, KeyManager keyManager, MouseManager mouseManager, Provider<ChatboxTextMenuInput> chatboxTextMenuInputProvider, Provider<ChatboxTextInput> chatboxTextInputProvider) {
        this.client = client2;
        this.clientThread = clientThread;
        this.eventBus = eventBus;
        this.keyManager = keyManager;
        this.mouseManager = mouseManager;
        this.chatboxTextMenuInputProvider = chatboxTextMenuInputProvider;
        this.chatboxTextInputProvider = chatboxTextInputProvider;
        eventBus.register(this);
    }

    public void close() {
        this.clientThread.invokeLater(this::unsafeCloseInput);
    }

    private void unsafeCloseInput() {
        this.client.runScript(299, 0, 1, 0);
        if (this.currentInput != null) {
            this.killCurrentPanel();
        }
    }

    private void unsafeOpenInput(ChatboxInput input) {
        this.client.runScript(677, 0);
        this.eventBus.register(input);
        if (input instanceof KeyListener) {
            this.keyManager.registerKeyListener((KeyListener)((Object)input));
        }
        if (input instanceof MouseListener) {
            this.mouseManager.registerMouseListener((MouseListener)((Object)input));
        }
        if (input instanceof MouseWheelListener) {
            this.mouseManager.registerMouseWheelListener((MouseWheelListener)((Object)input));
        }
        if (this.currentInput != null) {
            this.killCurrentPanel();
        }
        this.currentInput = input;
        this.client.setVarcIntValue(5, InputType.RUNELITE_CHATBOX_PANEL.getType());
        this.client.getWidget(0xA2002A).setHidden(true);
        this.client.getWidget(10616875).setHidden(true);
        Widget c2 = this.getContainerWidget();
        c2.deleteAllChildren();
        c2.setOnDialogAbortListener(ev2 -> this.unsafeCloseInput());
        input.open();
    }

    public void openInput(ChatboxInput input) {
        this.clientThread.invokeLater(() -> this.unsafeOpenInput(input));
    }

    public ChatboxTextMenuInput openTextMenuInput(String title) {
        return this.chatboxTextMenuInputProvider.get().title(title);
    }

    public ChatboxTextInput openTextInput(String prompt) {
        return this.chatboxTextInputProvider.get().prompt(prompt);
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired ev2) {
        if (this.currentInput != null && ev2.getScriptId() == 299) {
            this.killCurrentPanel();
        }
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged ev2) {
        if (this.currentInput != null && ev2.getGameState() == GameState.LOGIN_SCREEN) {
            this.killCurrentPanel();
        }
    }

    private void killCurrentPanel() {
        try {
            this.currentInput.close();
        }
        catch (Exception e2) {
            log.warn("Exception closing {}", (Object)this.currentInput.getClass(), (Object)e2);
        }
        this.eventBus.unregister(this.currentInput);
        if (this.currentInput instanceof KeyListener) {
            this.keyManager.unregisterKeyListener((KeyListener)((Object)this.currentInput));
        }
        if (this.currentInput instanceof MouseListener) {
            this.mouseManager.unregisterMouseListener((MouseListener)((Object)this.currentInput));
        }
        if (this.currentInput instanceof MouseWheelListener) {
            this.mouseManager.unregisterMouseWheelListener((MouseWheelListener)((Object)this.currentInput));
        }
        this.currentInput = null;
    }

    public Widget getContainerWidget() {
        return this.client.getWidget(10616870);
    }

    public boolean shouldTakeInput() {
        Widget worldMapSearch = this.client.getWidget(38993946);
        return worldMapSearch == null || this.client.getVarcIntValue(190) != 1;
    }

    public ChatboxInput getCurrentInput() {
        return this.currentInput;
    }
}

