/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.game;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import javax.annotation.Nullable;
import net.runelite.client.game.ItemVariationMapping;

public enum ItemMapping {
    ITEM_AHRIMS_HOOD(4708, 4859, 4858, 4857, 4856, 30445, 30537, 30531, 30525, 30519),
    ITEM_AHRIMS_HOOD_0(4860, 30543),
    ITEM_AHRIMS_ROBETOP(4712, 4871, 4870, 4869, 4868, 30447, 30539, 30533, 30527, 30521),
    ITEM_AHRIMS_ROBETOP_0(4872, 30545),
    ITEM_AHRIMS_ROBEBOTTOM(4714, 4877, 4876, 4875, 4874, 30449, 30541, 30535, 30529, 30523),
    ITEM_AHRIMS_ROBEBOTTOM_0(4878, 30547),
    ITEM_AHRIMS_STAFF(4710, 4865, 4864, 4863, 4862, 30568, 30573, 30572, 30571, 30570),
    ITEM_AHRIMS_STAFF_0(4866, 30574),
    ITEM_ECHO_AHRIMS_HOOD(30445, 30537, 30531, 30525, 30519),
    ITEM_ECHO_AHRIMS_ROBETOP(30447, 30539, 30533, 30527, 30521),
    ITEM_ECHO_AHRIMS_ROBEBOTTOM(30449, 30541, 30535, 30529, 30523),
    ITEM_ECHO_AHRIMS_STAFF(30568, 30573, 30572, 30571, 30570),
    ITEM_KARILS_COIF(4732, 4931, 4930, 4929, 4928),
    ITEM_KARILS_LEATHERTOP(4736, 4943, 4942, 4941, 4940),
    ITEM_KARILS_LEATHERSKIRT(4738, 4949, 4948, 4947, 4946),
    ITEM_KARILS_CROSSBOW(4734, 4937, 4936, 4935, 4934),
    ITEM_DHAROKS_HELM(4716, 4883, 4882, 4881, 4880),
    ITEM_DHAROKS_PLATEBODY(4720, 4895, 4894, 4893, 4892),
    ITEM_DHAROKS_PLATELEGS(4722, 4901, 4900, 4899, 4898),
    ITEM_DHAROKS_GREATEAXE(4718, 4889, 4888, 4887, 4886),
    ITEM_GUTHANS_HELM(4724, 4907, 4906, 4905, 4904),
    ITEM_GUTHANS_PLATEBODY(4728, 4919, 4918, 4917, 4916),
    ITEM_GUTHANS_CHAINSKIRT(4730, 4925, 4924, 4923, 4922),
    ITEM_GUTHANS_WARSPEAR(4726, 4913, 4912, 4911, 4910),
    ITEM_TORAGS_HELM(4745, 4955, 4954, 4953, 4952),
    ITEM_TORAGS_PLATEBODY(4749, 4967, 4966, 4965, 4964),
    ITEM_TORAGS_PLATELEGS(4751, 4973, 4972, 4971, 4970),
    ITEM_TORAGS_HAMMERS(4747, 4961, 4960, 4959, 4958),
    ITEM_VERACS_HELM(4753, 4979, 4978, 4977, 4976),
    ITEM_VERACS_BRASSARD(4757, 4991, 4990, 4989, 4988),
    ITEM_VERACS_PLATESKIRT(4759, 4997, 4996, 4995, 4994),
    ITEM_VERACS_FLAIL(4755, 4985, 4984, 4983, 4982),
    ITEM_DRAGON_2H_SWORD(7158, 28051),
    ITEM_DRAGON_BATTLEAXE(1377, 28037),
    ITEM_DRAGON_CLAWS(13652, 28039),
    ITEM_DRAGON_CROSSBOW(21902, 28053),
    ITEM_DRAGON_DAGGER(1215, 28019),
    ITEM_DRAGON_DAGGER_P(1231, 28021),
    ITEM_DRAGON_DAGGER_P_(5680, 28023),
    ITEM_DRAGON_DAGGER_P__(5698, 28025),
    ITEM_DRAGON_HALBERD(3204, 28049),
    ITEM_DRAGON_SCIMITAR(4587, 20000, 28031),
    ITEM_DRAGON_SCIMITAR_ORNAMENT_KIT(20002, 20000),
    ITEM_DRAGON_SPEAR(1249, 28041),
    ITEM_DRAGON_SPEAR_P(1263, 28043),
    ITEM_DRAGON_SPEAR_P_(5716, 28045),
    ITEM_DRAGON_SPEAR_P__(5730, 28047),
    ITEM_DRAGON_SWORD(21009, 28029),
    ITEM_DRAGON_WARHAMMER(13576, 28035),
    ITEM_DRAGON_DEFENDER(20143, 19722),
    ITEM_DRAGON_PICKAXE(11920, 12797, 23677, 25376),
    ITEM_DRAGON_PICKAXE_OR(23908, 23677),
    ITEM_DRAGON_AXE(6739, 25378),
    ITEM_DRAGON_HARPOON(21028, 25373),
    ITEM_INFERNAL_PICKAXE_OR(13243, 25063),
    ITEM_INFERNAL_PICKAXE_OR_UNCHARGED(13244, 25369),
    ITEM_INFERNAL_AXE_OR(13241, 25066),
    ITEM_INFERNAL_AXE_OR_UNCHARGED(13242, 25371),
    ITEM_INFERNAL_HARPOON_OR(21031, 25059),
    ITEM_INFERNAL_HARPOON_OR_UNCHARGED(21033, 25367),
    ITEM_TRAILBLAZER_TOOL_ORNAMENT_KIT(25090, 25376, 25378, 25373, 25063, 25066, 25059, 25369, 25371, 25367),
    ITEM_DRAGON_KITESHIELD(21895, 22244),
    ITEM_DRAGON_KITESHIELD_ORNAMENT_KIT(22239, 22244),
    ITEM_DRAGON_FULL_HELM(11335, 12417),
    ITEM_DRAGON_FULL_HELM_ORNAMENT_KIT(12538, 12417),
    ITEM_DRAGON_MED_HELM(1149, 28057),
    ITEM_DRAGON_CHAINBODY(3140, 12414, 28065),
    ITEM_DRAGON_CHAINBODY_ORNAMENT_KIT(12534, 12414),
    ITEM_DRAGON_PLATEBODY(21892, 22242),
    ITEM_DRAGON_PLATEBODY_ORNAMENT_KIT(22236, 22242),
    ITEM_DRAGON_PLATESKIRT(4585, 12416, 28063),
    ITEM_DRAGON_SKIRT_ORNAMENT_KIT(12536, 12416),
    ITEM_DRAGON_PLATELEGS(4087, 12415, 28061),
    ITEM_DRAGON_LEGS_ORNAMENT_KIT(12536, 12415),
    ITEM_DRAGON_SQ_SHIELD(1187, 12418, 28059),
    ITEM_DRAGON_SQ_SHIELD_ORNAMENT_KIT(12532, 12418),
    ITEM_DRAGON_BOOTS(11840, 22234, 28055),
    ITEM_DRAGON_BOOTS_ORNAMENT_KIT(22231, 22234),
    ITEM_RUNE_SCIMITAR_GUTHIX(1333, 23330),
    ITEM_RUNE_SCIMITAR_ORNAMENT_KIT_GUTHIX(23321, 23330),
    ITEM_RUNE_SCIMITAR_SARADOMIN(1333, 23332),
    ITEM_RUNE_SCIMITAR_ORNAMENT_KIT_SARADOMIN(23324, 23332),
    ITEM_RUNE_SCIMITAR_ZAMORAK(1333, 23334),
    ITEM_RUNE_SCIMITAR_ORNAMENT_KIT_ZAMORAK(23327, 23334),
    ITEM_RUNE_DEFENDER(8850, 23230, 27009),
    ITEM_RUNE_DEFENDER_ORNAMENT_KIT(23227, 23230, 27009),
    ITEM_RUNE_CROSSBOW(9185, 26486),
    ITEM_ARMADYL_GODSWORD(11802, 20368, 29605),
    ITEM_ARMADYL_GODSWORD_ORNAMENT_KIT(20068, 20368),
    ITEM_BANDOS_GODSWORD(11804, 20370),
    ITEM_BANDOS_GODSWORD_ORNAMENT_KIT(20071, 20370),
    ITEM_ZAMORAK_GODSWORD(11808, 20374),
    ITEM_ZAMORAK_GODSWORD_ORNAMENT_KIT(20077, 20374),
    ITEM_SARADOMIN_GODSWORD(11806, 20372),
    ITEM_SARADOMIN_GODSWORD_ORNAMENT_KIT(20074, 20372),
    ITEM_AMULET_OF_TORTURE(19553, 20366),
    ITEM_TORTURE_ORNAMENT_KIT(20062, 20366),
    ITEM_NECKLACE_OF_ANGUISH(19547, 22249),
    ITEM_ANGUISH_ORNAMENT_KIT(22246, 22249),
    ITEM_OCCULT_NECKLACE(12002, 19720),
    ITEM_OCCULT_ORNAMENT_KIT(20065, 19720),
    ITEM_AMULET_OF_FURY(6585, 12436, 24780),
    ITEM_FURY_ORNAMENT_KIT(12526, 12436),
    ITEM_TORMENTED_BRACELET(19544, 23444),
    ITEM_TORMENTED_ORNAMENT_KIT(23348, 23444),
    ITEM_BERSERKER_NECKLACE(11128, 23240),
    ITEM_BERSERKER_NECKLACE_ORNAMENT_KIT(23237, 23240),
    ITEM_SHATTERED_RELICS_VARIETY_ORNAMENT_KIT(26421, 26486, 26484, 26482, 26488, 26490, 26492, 26494, 26496, 26498),
    ITEM_SHATTERED_RELICS_VOID_ORNAMENT_KIT(26479, 26469, 26471, 26463, 26465, 26467, 26473, 26477, 26475, 27000, 27001, 27002, 27003, 27004, 27005, 27006, 27007),
    ITEM_MYSTIC_BOOTS(4097, 26539),
    ITEM_MYSTIC_GLOVES(4095, 26537),
    ITEM_MYSTIC_HAT(4089, 26531),
    ITEM_MYSTIC_ROBE_BOTTOM(4093, 26535),
    ITEM_MYSTIC_ROBE_TOP(4091, 26533),
    ITEM_SHATTERED_RELICS_MYSTIC_ORNAMENT_KIT(26541, 26539, 26537, 26531, 26535, 26533),
    ITEM_CANNON_BARRELS(10, 26524),
    ITEM_CANNON_BASE(6, 26520),
    ITEM_CANNON_FURNACE(12, 26526),
    ITEM_CANNON_STAND(8, 26522),
    ITEM_SHATTERED_CANNON_ORNAMENT_KIT(26528, 26524, 26520, 26526, 26522),
    ITEM_ELDER_MAUL(21003, 27100),
    ITEM_HEAVY_BALLISTA(19481, 26712),
    ITEM_ELDER_CHAOS_HOOD(20595, 27119),
    ITEM_ELDER_CHAOS_TOP(20517, 27115),
    ITEM_ELDER_CHAOS_ROBE(20520, 27117),
    ITEM_TRAILBLAZER_RELOADED_BLOWPIPE_ORNAMENT_KIT(28690, 28688, 28687),
    ITEM_DINHS_BULWARK(21015, 28682),
    ITEM_TRAILBLAZER_RELOADED_BULWARK_ORNAMENT_KIT(28684, 28682),
    ITEM_ECHO_AHRIMS_ORNAMENT_KIT(30451, true, 1L, 30445, 30447, 30449, 30568),
    ITEM_VIRTUS_MASK(26241, 30437),
    ITEM_VIRTUS_ROBE_TOP(26243, 30439),
    ITEM_VIRTUS_ROBE_BOTTOM(26245, 30441),
    ITEM_ECHO_VIRTUS_ORNAMENT_KIT(30443, 30437, 30439, 30441),
    ITEM_ECHO_VENATOR_BOW_ORNAMENT_KIT(30432, 30436, 30434),
    ITEM_ENSOULED_GOBLIN_HEAD(13448, 13447),
    ITEM_ENSOULED_MONKEY_HEAD(13451, 13450),
    ITEM_ENSOULED_IMP_HEAD(13454, 13453),
    ITEM_ENSOULED_MINOTAUR_HEAD(13457, 13456),
    ITEM_ENSOULED_SCORPION_HEAD(13460, 13459),
    ITEM_ENSOULED_BEAR_HEAD(13463, 13462),
    ITEM_ENSOULED_UNICORN_HEAD(13466, 13465),
    ITEM_ENSOULED_DOG_HEAD(13469, 13468),
    ITEM_ENSOULED_CHAOS_DRUID_HEAD(13472, 13471),
    ITEM_ENSOULED_GIANT_HEAD(13475, 13474),
    ITEM_ENSOULED_OGRE_HEAD(13478, 13477),
    ITEM_ENSOULED_ELF_HEAD(13481, 13480),
    ITEM_ENSOULED_TROLL_HEAD(13484, 13483),
    ITEM_ENSOULED_HORROR_HEAD(13487, 13486),
    ITEM_ENSOULED_KALPHITE_HEAD(13490, 13489),
    ITEM_ENSOULED_DAGANNOTH_HEAD(13493, 13492),
    ITEM_ENSOULED_BLOODVELD_HEAD(13496, 13495),
    ITEM_ENSOULED_TZHAAR_HEAD(13499, 13498),
    ITEM_ENSOULED_DEMON_HEAD(13502, 13501),
    ITEM_ENSOULED_HELLHOUND_HEAD(26997, 26996),
    ITEM_ENSOULED_AVIANSIE_HEAD(13505, 13504),
    ITEM_ENSOULED_ABYSSAL_HEAD(13508, 13507),
    ITEM_ENSOULED_DRAGON_HEAD(13511, 13510),
    ITEM_BERSERKER_RING(6737, true, 1L, 11773),
    ITEM_SEERS_RING(6731, true, 1L, 11770),
    ITEM_WARRIOR_RING(6735, true, 1L, 11772),
    ITEM_ARCHERS_RING(6733, true, 1L, 11771),
    ITEM_TREASONOUS_RING(12605, true, 1L, 12692),
    ITEM_TYRANNICAL_RING(12603, true, 1L, 12691),
    ITEM_RING_OF_THE_GODS(12601, true, 1L, 13202),
    ITEM_RING_OF_SUFFERING(19550, true, 1L, 19710),
    ITEM_GRANITE_RING(21739, true, 1L, 21752),
    ITEM_GRANITE_MAUL(4153, 12848),
    ITEM_MAGIC_SHORTBOW(861, 12788),
    ITEM_MAGIC_SHORTBOW_SCROLL(12786, 12788),
    ITEM_SARADOMINS_BLESSED_SWORD(12804, 12809),
    ITEM_ABYSSAL_DAGGER(13265, 27861),
    ITEM_DRAGON_LONGSWORD(1305, 27859, 28033),
    ITEM_DRAGON_MACE(1434, 27857, 28027),
    ITEM_RING_OF_WEALTH(2572, true, 1L, 11988),
    ITEM_RING_OF_WEALTH_SCROLL(12783, 12785, 20790, 20789, 20788, 20787, 20786),
    ITEM_AMULET_OF_GLORY(1704, 1706, 1708, 1710, 11976),
    ITEM_AMULET_OF_GLORY_T(10362, 10360, 10358, 10356, 11966),
    ITEM_SKILLS_NECKLACE(11113, 11111, 11109, 11107, 11970),
    ITEM_RING_OF_DUELING(2552, 2566, 2564, 2562, 2560, 2558, 2556, 2554),
    ITEM_GAMES_NECKLACE(3853, 3867, 3865, 3863, 3861, 3859, 3857, 3855),
    ITEM_RING_OF_THE_ELEMENTS(26815, 26818),
    ITEM_ABYSSAL_WHIP(4151, 12773, 12774, 26482),
    ITEM_KRAKEN_TENTACLE(12004, 12006, 26484),
    ITEM_TRIDENT_OF_THE_SEAS(11908, 11907),
    ITEM_TRIDENT_OF_THE_SEAS_E(22290, 22288),
    ITEM_TRIDENT_OF_THE_SWAMP(12900, 12899),
    ITEM_TRIDENT_OF_THE_SWAMP_E(22294, 22292),
    ITEM_TOXIC_BLOWPIPE(12924, 12926, 28687, 28688),
    ITEM_TOXIC_STAFF_OFF_THE_DEAD(12902, 12904),
    ITEM_SERPENTINE_HELM(12929, 12931, 13196, 13197, 13198, 13199),
    ITEM_DRAGONFIRE_SHIELD(11284, 11283),
    ITEM_DRAGONFIRE_WARD(22003, 22002),
    ITEM_ANCIENT_WYVERN_SHIELD(21634, 21633),
    ITEM_SANGUINESTI_STAFF(22481, 22323, 25733, 25731),
    ITEM_SCYTHE_OF_VITUR(22486, 22325, 25738, 25736, 25741, 25739),
    ITEM_TOME_OF_FIRE(20716, 20714),
    ITEM_TOME_OF_WATER(25576, 25574),
    ITEM_TOME_OF_EARTH(30066, 30064),
    ITEM_CRAWS_BOW(22547, 22550),
    ITEM_VIGGORAS_CHAINMACE(22542, 22545),
    ITEM_THAMMARONS_SCEPTRE(22552, 22555),
    ITEM_WEBWEAVER_BOW(27652, 27655),
    ITEM_URSINE_CHAINMACE(27657, 27660),
    ITEM_ACCURSED_SCEPTRE(27662, 27665),
    ITEM_ACCURSED_SCEPTRE_A(27676, 27679),
    ITEM_BRYOPHYTAS_STAFF(22368, 22370),
    ITEM_RING_OF_ENDURANCE(24844, 24736),
    ITEM_TUMEKENS_SHADOW(27277, 27275),
    ITEM_PHARAOHS_SCEPTRE(26945, true, 1L, 9044),
    ITEM_VENATOR_BOW(27612, 27610, 30436, 30434),
    ITEM_TONALZTICS_OF_RALOS(28919, 28922),
    ITEM_GUARDIAN_BOOTS(21733, 28945),
    ITEM_BLUE_MOON_HELM(29019, 29041),
    ITEM_BLUE_MOON_CHESTPLATE(29013, 29037),
    ITEM_BLUE_MOON_TASSETS(29016, 29039),
    ITEM_ECLIPSE_MOON_HELM(29010, 29035),
    ITEM_ECLIPSE_MOON_CHESTPLATE(29004, 29031),
    ITEM_ECLIPSE_MOON_TASSETS(29007, 29033),
    ITEM_BLOOD_MOON_HELM(29028, 29047),
    ITEM_BLOOD_MOON_CHESTPLATE(29022, 29043),
    ITEM_BLOOD_MOON_TASSETS(29025, 29045),
    ITEM_ELIDINIS_WARD(25985, 27251, 27253),
    ITEM_OSMUMTENS_FANG(26219, 27246),
    ITEM_INFINITY_TOP(6916, 20574, 12458, 12420),
    ITEM_INFINITY_TOP_LIGHT_COLOUR_KIT(12530, 12420),
    ITEM_INFINITY_TOP_DARK_COLOUR_KIT(12528, 12458),
    ITEM_INFINITY_BOTTOMS(6924, 20575, 12459, 12421),
    ITEM_INFINITY_BOTTOMS_LIGHT_COLOUR_KIT(12530, 12421),
    ITEM_INFINITY_BOTTOMS_DARK_COLOUR_KIT(12528, 12459),
    ITEM_INFINITY_HAT(6918, 12457, 12419),
    ITEM_INFINITY_HAT_LIGHT_COLOUR_KIT(12530, 12419),
    ITEM_INFINITY_HAT_DARK_COLOUR_KIT(12528, 12457),
    ITEM_DARK_BOW(11235, 12765, 12766, 12767, 12768, 20408, 27853, 29611),
    ITEM_ODIUM_WARD(11926, 12807),
    ITEM_MALEDICTION_WARD(11924, 12806),
    ITEM_STEAM_BATTLESTAFF(11787, 12795),
    ITEM_LAVA_BATTLESTAFF(3053, 21198),
    ITEM_TZHAAR_KET_OM(6528, 23235),
    ITEM_TZHAAR_KET_OM_ORNAMENT_KIT(23232, 23235),
    ITEM_DRAGON_HUNTER_CROSSBOW(21012, 25918, 25916),
    ITEM_VOIDWAKER(27690, 29607),
    ITEM_AMULET_OF_RANCOUR(29801, 29804),
    ITEM_BLACK_MASK(8921, true, 1L, 8921, 11864),
    ITEM_HYDRA_LEATHER(22983, 22981),
    ITEM_HYDRA_TAIL(22988, 22986),
    ITEM_DRAGONBONE_NECKLACE(22111, 22986),
    ITEM_BOTTOMLESS_COMPOST_BUCKET(22994, 22997),
    ITEM_BASILISK_JAW(24268, 24271),
    ITEM_HELM_OF_NEITIZNOT(10828, 24271, 28070),
    ITEM_TWISTED_HORNS(24466, 24370, 24444, 25191, 26681),
    ITEM_ELDRITCH_ORB(24517, 24425),
    ITEM_HARMONISED_ORB(24511, 24423),
    ITEM_VOLATILE_ORB(24514, 24424, 29609),
    ITEM_NIGHTMARE_STAFF(24422, 24425, 24423, 24424, 29609),
    ITEM_GHRAZI_RAPIER(22324, 25734),
    ITEM_MASTER_SCROLL_BOOK(21387, 21389),
    ITEM_ARCANE_SIGIL(12827, 27251, 27253),
    ITEM_TROUVER_PARCHMENT(24187, 24133, 24134, 24135, 24136, 24137, 24138, 24139, 24140, 24141, 24142, 24143, 24157, 24158, 24159, 24160, 24161, 24162, 24163, 24164, 24165, 24166, 24167, 24168, 24169, 24170, 24171, 24172, 24173, 24174, 24175, 24176, 24177, 24178, 24179, 24180, 24181, 24182, 24183, 24184, 24185, 24186, 24194, 24197, 24200, 24203, 24206, 24222, 24223, 24224, 24232, 24233, 24234, 24248, 24250, 24249, 24416, 24533, 25173, 25176, 27376, 27365, 27009, 27000, 27001, 27002, 27003, 27004, 27005, 27006, 27007, 25643),
    ITEM_TROUVER_PARCHMENT_REFUND_LARGE(995, 475000L, 24133, 24134, 24135, 24142, 24143, 24157, 24158, 24159, 24160, 24161, 24162, 24163, 24164, 24165, 24166, 24167, 24168, 24169, 24170, 24171, 24172, 24173, 24174, 24175, 24176, 24177, 24178, 24179, 24180, 24181, 24182, 24183, 24184, 24185, 24186, 24194, 24197, 24200, 24203, 24206, 24222, 24223, 24224, 24232, 24233, 24234, 24248, 24250, 24249, 24416, 24533, 25173, 25176, 27376, 27365, 27009, 27000, 27001, 27002, 27003, 27004, 27005, 27006, 27007, 25643),
    ITEM_TROUVER_PARCHMENT_REFUND_SMALL(995, 47500L, 24136, 24137, 24138, 24139, 24140, 24141),
    ITEM_CRYSTAL_TOOL_SEED(23953, 23673, 23675, 28220, 28223, 23762, 23764, 23680, 23682),
    ITEM_CRYSTAL_AXE(6739, 23673, 23675),
    ITEM_CRYSTAL_FELLING_AXE(28217, 28220, 28223),
    ITEM_CRYSTAL_HARPOON(21028, 23762, 23764),
    ITEM_CRYSTAL_PICKAXE(11920, 23680, 23682),
    ITEM_BLADE_OF_SAELDOR(23997, true, 1L, 23995),
    ITEM_CRYSTAL_BOW(4207, 23983, 24123, 23985),
    ITEM_CRYSTAL_HALBERD(4207, 23987, 24125, 23989),
    ITEM_CRYSTAL_SHIELD(4207, 23991, 24127, 23993),
    ITEM_CRYSTAL_HELMET(23956, true, 1L, 23971),
    ITEM_CRYSTAL_LEGS(23956, true, 2L, 23979),
    ITEM_CRYSTAL_BODY(23956, true, 3L, 23975),
    ITEM_BOW_OF_FAERDHINEN(25862, true, 1L, 25865),
    ITEM_BIRD_NEST(5075, 5070, 5071, 5072, 5073, 5074, 7413, 13653, 22798, 22800, 19712, 19714, 19716, 19718),
    ITEM_ANCESTRAL_HAT(21018, 24664),
    ITEM_ANCESTRAL_ROBE_TOP(21021, 24666),
    ITEM_ANCESTRAL_ROBE_BOTTOM(21024, 24668),
    ITEM_TORVA_FULL_HELM(26382, 28254),
    ITEM_TORVA_PLATEBODY(26384, 28256),
    ITEM_TORVA_PLATELEGS(26386, 28258),
    ITEM_MARK_OF_GRACE(12640, true, 10L, 11849),
    ITEM_GRACEFUL_HOOD(11849, true, 28L, 11850),
    ITEM_GRACEFUL_TOP(11849, true, 44L, 11854),
    ITEM_GRACEFUL_LEGS(11849, true, 48L, 11856),
    ITEM_GRACEFUL_GLOVES(11849, true, 24L, 11858),
    ITEM_GRACEFUL_BOOTS(11849, true, 32L, 11860),
    ITEM_GRACEFUL_CAPE(11849, true, 32L, 11852),
    ITEM_TRAILBLAZER_GRACEFUL_HOOD(25099, 25069),
    ITEM_TRAILBLAZER_GRACEFUL_TOP(25099, 25075),
    ITEM_TRAILBLAZER_GRACEFUL_LEGS(25099, 25078),
    ITEM_TRAILBLAZER_GRACEFUL_GLOVES(25099, 25081),
    ITEM_TRAILBLAZER_GRACEFUL_BOOTS(25099, 25084),
    ITEM_TRAILBLAZER_GRACEFUL_CAPE(25099, 25072),
    ITEM_GOLDEN_NUGGET(1761, true, 10L, 12012),
    ITEM_PROSPECTOR_HELMET(12012, true, 32L, 12013),
    ITEM_PROSPECTOR_JACKET(12012, true, 48L, 12014),
    ITEM_PROSPECTOR_LEGS(12012, true, 40L, 12015),
    ITEM_PROSPECTOR_BOOTS(12012, true, 24L, 12016),
    ITEM_UNIDENTIFIED_MINERALS(1761, true, 10L, 21341),
    ITEM_TATTERED_PAGE(995, true, 1000L, 23510, 23512, 23514),
    ITEM_LONG_BONE(995, true, 1000L, 10976),
    ITEM_CURVED_BONE(995, true, 2000L, 10977),
    ITEM_PERFECT_SHELL(995, true, 600L, 10995),
    ITEM_PERFECT_SNAIL_SHELL(995, true, 600L, 10996),
    ITEM_SNAIL_SHELL(995, true, 600L, 7800),
    ITEM_TORTOISE_SHELL(995, true, 250L, 7939);

    @VisibleForTesting
    static final Multimap<Integer, ItemMapping> MAPPINGS;
    private final int tradeableItem;
    private final int[] untradableItems;
    private final long quantity;
    private final boolean includeVariations;

    private ItemMapping(int tradeableItem, boolean includeVariations, long quantity, int ... untradableItems) {
        this.tradeableItem = tradeableItem;
        this.untradableItems = untradableItems;
        this.quantity = quantity;
        this.includeVariations = includeVariations;
    }

    private ItemMapping(int tradeableItem, long quantity, int ... untradableItems) {
        this(tradeableItem, false, quantity, untradableItems);
    }

    private ItemMapping(int tradeableItem, int ... untradableItems) {
        this(tradeableItem, 1L, untradableItems);
    }

    @Nullable
    public static Collection<ItemMapping> map(int itemId) {
        Collection<ItemMapping> mapping = MAPPINGS.get(itemId);
        if (mapping.isEmpty()) {
            return null;
        }
        return mapping;
    }

    public int getTradeableItem() {
        return this.tradeableItem;
    }

    public int[] getUntradableItems() {
        return this.untradableItems;
    }

    public long getQuantity() {
        return this.quantity;
    }

    public boolean isIncludeVariations() {
        return this.includeVariations;
    }

    static {
        MAPPINGS = HashMultimap.create();
        for (ItemMapping item : ItemMapping.values()) {
            for (int itemId : item.untradableItems) {
                if (item.includeVariations) {
                    for (Integer variation : ItemVariationMapping.getVariations(ItemVariationMapping.map(itemId))) {
                        if (variation == item.tradeableItem) continue;
                        MAPPINGS.put(variation, item);
                    }
                    continue;
                }
                MAPPINGS.put(itemId, item);
            }
        }
    }
}

