/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigData {
    private static final Logger log = LoggerFactory.getLogger(ConfigData.class);
    private final File configPath;
    private final ConcurrentHashMap<String, String> properties;
    private Map<String, String> patchChanges = new HashMap<String, String>();

    ConfigData(File configPath) {
        this.configPath = configPath;
        Properties props = new Properties();
        try (FileInputStream in22 = new FileInputStream(configPath);
             InputStreamReader reader = new InputStreamReader((InputStream)in22, StandardCharsets.UTF_8);){
            props.load(reader);
        }
        catch (FileNotFoundException in22) {
        }
        catch (Exception ex2) {
            throw new RuntimeException(ex2);
        }
        this.properties = new ConcurrentHashMap(props.size());
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k2, v2) -> this.properties.put((String)k2, (String)v2)));
    }

    String getProperty(String key) {
        return this.properties.get(key);
    }

    synchronized String setProperty(String key, String value) {
        String old = this.properties.put(key, value);
        if (!Objects.equals(old, value)) {
            this.patchChanges.put(key, value);
        }
        return old;
    }

    synchronized String unset(String key) {
        String old = this.properties.remove(key);
        if (old != null) {
            this.patchChanges.put(key, null);
        }
        return old;
    }

    synchronized void putAll(Map<String, String> values) {
        this.patchChanges.putAll(values);
        this.properties.putAll(values);
    }

    Set<String> keySet() {
        return this.properties.keySet();
    }

    Map<String, String> get() {
        return Collections.unmodifiableMap(this.properties);
    }

    synchronized Map<String, String> swapChanges() {
        if (this.patchChanges.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, String> p2 = this.patchChanges;
        this.patchChanges = new HashMap<String, String>();
        return p2;
    }

    void patch(Map<String, String> patch) {
        File lckFile = new File(this.configPath.getParentFile(), this.configPath.getName() + ".lck");
        try (FileOutputStream lockOut = new FileOutputStream(lckFile);
             FileChannel lckChannel = lockOut.getChannel();){
            lckChannel.lock();
            Properties tempProps = new Properties();
            try (FileInputStream in2 = new FileInputStream(this.configPath);
                 InputStreamReader reader = new InputStreamReader((InputStream)in2, StandardCharsets.UTF_8);){
                tempProps.load(reader);
            }
            catch (FileNotFoundException e2) {
                log.debug("config file {} does not exist", (Object)this.configPath);
            }
            if (tempProps.isEmpty()) {
                tempProps.putAll((Map<?, ?>)this.properties);
            } else {
                for (Map.Entry<String, String> entry : patch.entrySet()) {
                    if (entry.getValue() == null) {
                        tempProps.remove(entry.getKey());
                        continue;
                    }
                    tempProps.put(entry.getKey(), entry.getValue());
                }
            }
            File tempFile = File.createTempFile("runelite_config", null, this.configPath.getParentFile());
            try (FileOutputStream out = new FileOutputStream(tempFile);
                 FileChannel channel = out.getChannel();
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
                channel.lock();
                tempProps.store(writer, "RuneLite configuration");
                writer.flush();
                channel.force(true);
            }
            try {
                Files.move(tempFile.toPath(), this.configPath.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException ex2) {
                log.debug("atomic move not supported", ex2);
                Files.move(tempFile.toPath(), this.configPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ex3) {
            log.error("unable to save configuration file", ex3);
        }
        lckFile.delete();
    }
}

