/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.mesh;

import com.github.weisj.jsvg.geometry.mesh.CoonPatch;
import com.github.weisj.jsvg.geometry.mesh.CoonValues;
import com.github.weisj.jsvg.geometry.mesh.Subdivided;
import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import com.github.weisj.jsvg.nodes.Stop;
import com.github.weisj.jsvg.nodes.container.ContainerNode;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.renderer.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.jetbrains.annotations.NotNull;

@ElementCategories(value={})
@PermittedContent(categories={Category.Descriptive}, anyOf={Stop.class})
public final class MeshPatch
extends ContainerNode {
    public static final String TAG = "meshpatch";
    private static final int MAX_DEPTH = 10;
    Color north;
    Color east;
    Color south;
    Color west;
    @NotNull
    final CoonPatch coonPatch = CoonPatch.createUninitialized();

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    public void renderPath(@NotNull Graphics2D g2) {
        AffineTransform at2 = g2.getTransform();
        float scaleX = (float)GeometryUtil.scaleYOfTransform(at2);
        float scaleY = (float)GeometryUtil.scaleYOfTransform(at2);
        int depth = Math.max(Math.max(this.coonPatch.north.estimateStepCount(scaleX, scaleY), this.coonPatch.east.estimateStepCount(scaleX, scaleY)), Math.max(this.coonPatch.south.estimateStepCount(scaleX, scaleY), this.coonPatch.west.estimateStepCount(scaleX, scaleY)));
        this.renderPath(g2, this.coonPatch, scaleX, scaleY, Math.min(10, depth));
    }

    private void renderPath(@NotNull Graphics2D g2, @NotNull CoonPatch patch, float scaleX, float scaleY, int depth) {
        CoonValues weights = patch.coonValues;
        if (depth == 0 || GeometryUtil.distanceSquared(weights.north, weights.south, scaleX, scaleY) * GeometryUtil.distanceSquared(weights.east, weights.west, scaleX, scaleY) < 1.0E-6) {
            float u2 = (weights.north.x + weights.east.x + weights.south.x + weights.west.x) / 4.0f;
            float v2 = (weights.north.y + weights.east.y + weights.south.y + weights.west.y) / 4.0f;
            GraphicsUtil.safelySetPaint(g2, this.bilinearInterpolation(u2, v2));
            Shape s2 = patch.toShape();
            g2.fill(s2.getBounds2D());
        } else {
            Subdivided<CoonPatch> patchSubdivided = patch.subdivide();
            this.renderPath(g2, (CoonPatch)patchSubdivided.northWest, scaleX, scaleY, depth - 1);
            this.renderPath(g2, (CoonPatch)patchSubdivided.northEast, scaleX, scaleY, depth - 1);
            this.renderPath(g2, (CoonPatch)patchSubdivided.southEast, scaleX, scaleY, depth - 1);
            this.renderPath(g2, (CoonPatch)patchSubdivided.southWest, scaleX, scaleY, depth - 1);
        }
    }

    @NotNull
    private Color bilinearInterpolation(float dx2, float dy2) {
        float r2 = GeometryUtil.lerp(dy2, GeometryUtil.lerp(dx2, this.north.getRed(), this.east.getRed()), GeometryUtil.lerp(dx2, this.west.getRed(), this.south.getRed()));
        float g2 = GeometryUtil.lerp(dy2, GeometryUtil.lerp(dx2, this.north.getGreen(), this.east.getGreen()), GeometryUtil.lerp(dx2, this.west.getGreen(), this.south.getGreen()));
        float b2 = GeometryUtil.lerp(dy2, GeometryUtil.lerp(dx2, this.north.getBlue(), this.east.getBlue()), GeometryUtil.lerp(dx2, this.west.getBlue(), this.south.getBlue()));
        float a2 = GeometryUtil.lerp(dy2, GeometryUtil.lerp(dx2, this.north.getAlpha(), this.east.getAlpha()), GeometryUtil.lerp(dx2, this.west.getAlpha(), this.south.getAlpha()));
        return new Color(this.clampColor(r2), this.clampColor(g2), this.clampColor(b2), this.clampColor(a2));
    }

    private int clampColor(float v2) {
        return Math.max(Math.min(255, (int)v2), 0);
    }
}

