/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.UnitType;
import com.github.weisj.jsvg.attributes.filter.DefaultFilterChannel;
import com.github.weisj.jsvg.attributes.filter.FilterChannelKey;
import com.github.weisj.jsvg.attributes.filter.LayoutBounds;
import com.github.weisj.jsvg.geometry.size.FloatInsets;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.animation.Animate;
import com.github.weisj.jsvg.nodes.animation.Set;
import com.github.weisj.jsvg.nodes.container.ContainerNode;
import com.github.weisj.jsvg.nodes.filter.FilterContext;
import com.github.weisj.jsvg.nodes.filter.FilterLayoutContext;
import com.github.weisj.jsvg.nodes.filter.FilterPrimitive;
import com.github.weisj.jsvg.nodes.filter.IllegalFilterStateException;
import com.github.weisj.jsvg.nodes.filter.ImageProducerChannel;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.util.BlittableImage;
import com.github.weisj.jsvg.util.ImageUtil;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.RGBImageFilter;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ElementCategories(value={})
@PermittedContent(categories={Category.Descriptive, Category.FilterPrimitive}, anyOf={Animate.class, Set.class})
public final class Filter
extends ContainerNode {
    private static final boolean DEBUG = false;
    public static final String TAG = "filter";
    private static final Length DEFAULT_FILTER_COORDINATE = Unit.PERCENTAGE.valueOf(-10.0f);
    private static final Length DEFAULT_FILTER_SIZE = Unit.PERCENTAGE.valueOf(120.0f);
    private Length x;
    private Length y;
    private Length width;
    private Length height;
    private UnitType filterUnits;
    private UnitType filterPrimitiveUnits;
    private boolean isValid;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    public boolean hasEffect() {
        return this.isValid && !this.children().isEmpty();
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.isValid = true;
        for (SVGNode sVGNode : this.children()) {
            FilterPrimitive filterPrimitive = (FilterPrimitive)((Object)sVGNode);
            if (filterPrimitive.isValid()) continue;
            this.isValid = false;
            break;
        }
        this.filterUnits = attributeNode.getEnum("filterUnits", UnitType.ObjectBoundingBox);
        this.filterPrimitiveUnits = attributeNode.getEnum("primitiveUnits", UnitType.UserSpaceOnUse);
        this.x = attributeNode.getLength("x", DEFAULT_FILTER_COORDINATE);
        this.y = attributeNode.getLength("y", DEFAULT_FILTER_COORDINATE);
        this.width = attributeNode.getLength("width", DEFAULT_FILTER_SIZE);
        this.height = attributeNode.getLength("height", DEFAULT_FILTER_SIZE);
        if (this.filterUnits == UnitType.ObjectBoundingBox) {
            this.x = this.coerceToPercentage(this.x);
            this.y = this.coerceToPercentage(this.y);
            this.width = this.coerceToPercentage(this.width);
            this.height = this.coerceToPercentage(this.height);
        }
    }

    @NotNull
    private Length coerceToPercentage(@NotNull Length length) {
        if (length.unit() == Unit.PERCENTAGE) {
            return length;
        }
        return new Length(Unit.PERCENTAGE, length.raw() * 100.0f);
    }

    @NotNull
    public FilterInfo createFilterInfo(@NotNull Graphics2D g2, @NotNull RenderContext context, @NotNull Rectangle2D elementBounds) {
        Rectangle2D.Double filterRegion = this.filterUnits.computeViewBounds(context.measureContext(), elementBounds, this.x, this.y, this.width, this.height);
        Rectangle graphicsClipBounds = g2.getClipBounds();
        FilterLayoutContext filterLayoutContext = new FilterLayoutContext(this.filterPrimitiveUnits, elementBounds, graphicsClipBounds);
        Rectangle2D clippedElementBounds = elementBounds.createIntersection(graphicsClipBounds);
        Rectangle2D effectiveFilterRegion = filterRegion.createIntersection(graphicsClipBounds);
        LayoutBounds elementLayoutBounds = new LayoutBounds(effectiveFilterRegion, new FloatInsets());
        LayoutBounds clippedElementLayoutBounds = new LayoutBounds(clippedElementBounds, new FloatInsets());
        LayoutBounds sourceDependentBounds = elementLayoutBounds.transform((data, flags) -> flags.operatesOnWholeFilterRegion ? data : clippedElementLayoutBounds.resolve((LayoutBounds.ComputeFlags)flags));
        filterLayoutContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.LastResult, elementLayoutBounds);
        filterLayoutContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.SourceGraphic, sourceDependentBounds);
        filterLayoutContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.SourceAlpha, sourceDependentBounds);
        for (SVGNode sVGNode : this.children()) {
            try {
                FilterPrimitive filterPrimitive = (FilterPrimitive)((Object)sVGNode);
                filterPrimitive.layoutFilter(context, filterLayoutContext);
            }
            catch (IllegalFilterStateException filterPrimitive) {}
        }
        LayoutBounds.Data clipHeuristic = filterLayoutContext.resultChannels().get(DefaultFilterChannel.LastResult).resolve(LayoutBounds.ComputeFlags.INITIAL);
        FloatInsets floatInsets = clipHeuristic.clipBoundsEscapeInsets();
        Rectangle2D clipHeuristicBounds = clipHeuristic.bounds().createIntersection(GeometryUtil.grow(graphicsClipBounds, floatInsets));
        BlittableImage blitImage = BlittableImage.create(ImageUtil::createCompatibleTransparentImage, context, clipHeuristicBounds, filterRegion, elementBounds, UnitType.UserSpaceOnUse);
        return new FilterInfo(g2, blitImage, elementBounds);
    }

    public void applyFilter(@NotNull Graphics2D g2, @NotNull RenderContext context, @NotNull FilterInfo filterInfo) {
        ImageProducer producer = filterInfo.blittableImage.image().getSource();
        FilterContext filterContext = new FilterContext(filterInfo, this.filterPrimitiveUnits, g2.getRenderingHints());
        ImageProducerChannel sourceChannel = new ImageProducerChannel(producer);
        filterContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.SourceGraphic, sourceChannel);
        filterContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.LastResult, sourceChannel);
        filterContext.resultChannels().addResult((FilterChannelKey)DefaultFilterChannel.SourceAlpha, () -> sourceChannel.applyFilter(new AlphaImageFilter()));
        for (SVGNode sVGNode : this.children()) {
            try {
                FilterPrimitive filterPrimitive = (FilterPrimitive)((Object)sVGNode);
                filterPrimitive.applyFilter(context, filterContext);
            }
            catch (IllegalFilterStateException illegalFilterStateException) {}
        }
        filterInfo.producer = Objects.requireNonNull(filterContext.getChannel(DefaultFilterChannel.LastResult)).producer();
    }

    @Override
    protected boolean acceptChild(@Nullable String id2, @NotNull SVGNode node) {
        return node instanceof FilterPrimitive && super.acceptChild(id2, node);
    }

    public static final class FilterInfo {
        public final int imageWidth;
        public final int imageHeight;
        @NotNull
        private final Rectangle2D elementBounds;
        @NotNull
        private final Graphics2D imageGraphics;
        @NotNull
        private final BlittableImage blittableImage;
        private ImageProducer producer;

        private FilterInfo(@NotNull Graphics2D g2, @NotNull BlittableImage blittableImage, @NotNull Rectangle2D elementBounds) {
            this.blittableImage = blittableImage;
            this.elementBounds = elementBounds;
            BufferedImage image = blittableImage.image();
            this.imageWidth = image.getWidth();
            this.imageHeight = image.getHeight();
            this.imageGraphics = blittableImage.createGraphics();
            this.imageGraphics.setRenderingHints(g2.getRenderingHints());
        }

        @NotNull
        public Rectangle2D imageBounds() {
            return this.blittableImage.boundsInUserSpace();
        }

        @NotNull
        public Rectangle2D elementBounds() {
            return this.elementBounds;
        }

        @NotNull
        public Graphics2D graphics() {
            return this.imageGraphics;
        }

        @NotNull
        public Rectangle2D tile() {
            Rectangle2D imageBounds = this.imageBounds();
            return new Rectangle2D.Double(imageBounds.getX() - this.elementBounds.getX(), imageBounds.getY() - this.elementBounds.getY(), imageBounds.getWidth(), imageBounds.getHeight());
        }

        public void blitImage(@NotNull Graphics2D g2, @NotNull RenderContext context) {
            Rectangle2D imageBounds = this.imageBounds();
            this.blittableImage.prepareForBlitting(g2, context);
            g2.drawImage(context.createImage(this.producer), 0, 0, context.targetComponent());
        }

        public void close() {
            this.imageGraphics.dispose();
        }
    }

    private static final class AlphaImageFilter
    extends RGBImageFilter {
        private final ColorModel model = ColorModel.getRGBdefault();

        private AlphaImageFilter() {
        }

        @Override
        public int filterRGB(int x2, int y2, int rgb) {
            return this.model.getAlpha(rgb) << 24;
        }
    }
}

