/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes;

import com.github.weisj.jsvg.geometry.MeasurableShape;
import com.github.weisj.jsvg.geometry.SVGRectangle;
import com.github.weisj.jsvg.geometry.SVGRoundRectangle;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.nodes.ShapeNode;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.AttributeNode;
import org.jetbrains.annotations.NotNull;

@ElementCategories(value={Category.BasicShape, Category.Graphic, Category.Shape})
@PermittedContent(categories={Category.Animation, Category.Descriptive})
public final class Rect
extends ShapeNode {
    public static final String TAG = "rect";

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    @NotNull
    protected MeasurableShape buildShape(@NotNull AttributeNode node) {
        Length x2 = node.getLength("x", 0.0f);
        Length y2 = node.getLength("y", 0.0f);
        Length width = node.getLength("width", 0.0f);
        Length height = node.getLength("height", 0.0f);
        Length rx = node.getLength("rx", Length.UNSPECIFIED);
        Length ry = node.getLength("ry", rx);
        if (rx.isUnspecified()) {
            rx = ry;
        }
        rx = rx.coerceNonNegative().orElseIfUnspecified(0.0f);
        ry = ry.coerceNonNegative().orElseIfUnspecified(0.0f);
        if (rx.isZero() && ry.isZero()) {
            return new SVGRectangle(x2, y2, width, height);
        }
        return new SVGRoundRectangle(x2, y2, width, height, rx, ry);
    }
}

