/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry;

import com.github.weisj.jsvg.geometry.MeasurableShape;
import com.github.weisj.jsvg.geometry.SVGCircle;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public final class SVGEllipse
implements MeasurableShape {
    @NotNull
    private final Ellipse2D.Float ellipse = new Ellipse2D.Float();
    @NotNull
    private final Length cx;
    @NotNull
    private final Length cy;
    @NotNull
    private final Length rx;
    @NotNull
    private final Length ry;

    public SVGEllipse(@NotNull Length cx2, @NotNull Length cy2, @NotNull Length rx, @NotNull Length ry) {
        this.cx = cx2;
        this.cy = cy2;
        this.rx = rx;
        this.ry = ry;
    }

    private void validateShape(@NotNull MeasureContext measureContext) {
        float x2 = this.cx.resolveWidth(measureContext);
        float y2 = this.cy.resolveWidth(measureContext);
        float rrx = this.rx.resolveWidth(measureContext);
        float rry = this.ry.resolveHeight(measureContext);
        this.ellipse.setFrame(x2 - rrx, y2 - rry, 2.0f * rrx, 2.0f * rry);
    }

    @Override
    @NotNull
    public Shape shape(@NotNull RenderContext context, boolean validate) {
        if (validate) {
            this.validateShape(context.measureContext());
        }
        return this.ellipse;
    }

    @Override
    @NotNull
    public Rectangle2D bounds(@NotNull RenderContext context, boolean validate) {
        if (validate) {
            this.validateShape(context.measureContext());
        }
        return this.ellipse.getBounds2D();
    }

    @Override
    public double pathLength(@NotNull MeasureContext measureContext) {
        float b2;
        float a2 = this.rx.resolveWidth(measureContext);
        if (a2 == (b2 = this.ry.resolveHeight(measureContext))) {
            return SVGCircle.circumference(a2);
        }
        return SVGEllipse.ellipseCircumference(a2, b2);
    }

    static double ellipseCircumference(double a2, double b2) {
        double h2 = (a2 - b2) * (a2 - b2) / ((a2 + b2) * (a2 + b2));
        double h4 = h2 / 4.0;
        return 0.7853981633974483 * (a2 + b2) * (3.0 * (1.0 + h4) + 1.0 / (1.0 - h4));
    }
}

