/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.geometry;

import com.github.weisj.jsvg.geometry.MeasurableShape;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public final class SVGCircle
implements MeasurableShape {
    @NotNull
    private final Ellipse2D.Float circle = new Ellipse2D.Float();
    @NotNull
    private final Length cx;
    @NotNull
    private final Length cy;
    @NotNull
    private final Length r;

    public SVGCircle(@NotNull Length cx2, @NotNull Length cy2, @NotNull Length r2) {
        this.cx = cx2;
        this.cy = cy2;
        this.r = r2;
    }

    private void validateShape(@NotNull MeasureContext measureContext) {
        float x2 = this.cx.resolveWidth(measureContext);
        float y2 = this.cy.resolveWidth(measureContext);
        float rr = this.r.resolveLength(measureContext);
        this.circle.setFrame(x2 - rr, y2 - rr, 2.0f * rr, 2.0f * rr);
    }

    @Override
    @NotNull
    public Shape shape(@NotNull RenderContext context, boolean validate) {
        if (validate) {
            this.validateShape(context.measureContext());
        }
        return this.circle;
    }

    @Override
    @NotNull
    public Rectangle2D bounds(@NotNull RenderContext context, boolean validate) {
        if (validate) {
            this.validateShape(context.measureContext());
        }
        return this.circle.getBounds2D();
    }

    @Override
    public double pathLength(@NotNull MeasureContext measureContext) {
        return SVGCircle.circumference(this.r.resolveLength(measureContext));
    }

    static double circumference(double radius) {
        return Math.PI * 2 * radius;
    }
}

