/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.extras;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class FlatInspector {
    private static final Integer HIGHLIGHT_LAYER = JLayeredPane.POPUP_LAYER - 1;
    private static final int KEY_MODIFIERS_MASK = 960;
    private final JRootPane rootPane;
    private final MouseMotionListener mouseMotionListener;
    private final AWTEventListener keyListener;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final WindowListener windowListener;
    private Window window;
    private boolean enabled;
    private Object oldGlassPaneFullHeight;
    private Component lastComponent;
    private int lastX;
    private int lastY;
    private int inspectParentLevel;
    private boolean wasModifierKeyPressed;
    private boolean showClassHierarchy;
    private long lastWhen;
    private JComponent highlightFigure;
    private Popup popup;

    public static void install(String activationKeys) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(activationKeys);
        Toolkit.getDefaultToolkit().addAWTEventListener(e2 -> {
            if (e2.getID() == 402 && ((KeyEvent)e2).getKeyCode() == keyStroke.getKeyCode() && (((KeyEvent)e2).getModifiersEx() & 0x3C0) == (keyStroke.getModifiers() & 0x3C0)) {
                Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                RootPaneContainer rootPaneContainer = null;
                if (activeWindow instanceof RootPaneContainer) {
                    rootPaneContainer = (RootPaneContainer)((Object)activeWindow);
                } else {
                    for (Component child : activeWindow.getComponents()) {
                        if (!(child instanceof RootPaneContainer)) continue;
                        rootPaneContainer = (RootPaneContainer)((Object)child);
                        break;
                    }
                }
                if (rootPaneContainer != null) {
                    JRootPane rootPane = rootPaneContainer.getRootPane();
                    FlatInspector inspector = (FlatInspector)rootPane.getClientProperty(FlatInspector.class);
                    if (inspector == null) {
                        inspector = new FlatInspector(rootPane);
                        rootPane.putClientProperty(FlatInspector.class, inspector);
                        inspector.setEnabled(true);
                    } else {
                        inspector.setEnabled(false);
                        rootPane.putClientProperty(FlatInspector.class, null);
                    }
                }
            }
        }, 8L);
    }

    public FlatInspector(JRootPane rootPane) {
        this.rootPane = rootPane;
        this.mouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e2) {
                FlatInspector.this.lastX = e2.getX();
                FlatInspector.this.lastY = e2.getY();
                FlatInspector.this.inspect(FlatInspector.this.lastX, FlatInspector.this.lastY);
            }
        };
        this.keyListener = e2 -> {
            KeyEvent keyEvent = (KeyEvent)e2;
            int keyCode = keyEvent.getKeyCode();
            int id2 = e2.getID();
            if (id2 == 401) {
                if (keyCode == 17 || keyCode == 16 || keyCode == 18) {
                    this.wasModifierKeyPressed = true;
                }
            } else if (id2 == 402 && this.wasModifierKeyPressed) {
                int parentLevel;
                if (keyEvent.getWhen() - this.lastWhen <= 5L) {
                    return;
                }
                this.lastWhen = keyEvent.getWhen();
                if (keyCode == 17) {
                    ++this.inspectParentLevel;
                    parentLevel = this.inspect(this.lastX, this.lastY);
                    if (this.inspectParentLevel > parentLevel) {
                        this.inspectParentLevel = parentLevel;
                    }
                } else if (keyCode == 16 && this.inspectParentLevel > 0) {
                    --this.inspectParentLevel;
                    parentLevel = this.inspect(this.lastX, this.lastY);
                    if (this.inspectParentLevel > parentLevel) {
                        this.inspectParentLevel = Math.max(parentLevel - 1, 0);
                        this.inspect(this.lastX, this.lastY);
                    }
                } else if (keyCode == 18 && this.lastComponent != null) {
                    this.showClassHierarchy = !this.showClassHierarchy;
                    this.showToolTip(this.lastComponent, this.lastX, this.lastY, this.inspectParentLevel);
                }
            }
            if (keyCode == 27) {
                keyEvent.consume();
                if (id2 == 401) {
                    this.setEnabled(false);
                    FlatInspector inspector = (FlatInspector)rootPane.getClientProperty(FlatInspector.class);
                    if (inspector == this) {
                        rootPane.putClientProperty(FlatInspector.class, null);
                    }
                }
            }
        };
        this.windowListener = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e2) {
                FlatInspector.this.update();
            }

            @Override
            public void windowDeactivated(WindowEvent e2) {
                FlatInspector.this.hidePopup();
            }
        };
    }

    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.propertyChangeSupport.addPropertyChangeListener(l2);
    }

    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.propertyChangeSupport.removePropertyChangeListener(l2);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (enabled) {
            this.oldGlassPaneFullHeight = this.rootPane.getClientProperty("JRootPane.glassPaneFullHeight");
            this.rootPane.putClientProperty("JRootPane.glassPaneFullHeight", true);
            this.rootPane.validate();
        } else {
            this.rootPane.putClientProperty("JRootPane.glassPaneFullHeight", this.oldGlassPaneFullHeight);
        }
        ((JComponent)this.rootPane.getGlassPane()).setOpaque(false);
        this.rootPane.getGlassPane().setVisible(enabled);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (enabled) {
            toolkit.addAWTEventListener(this.keyListener, 8L);
        } else {
            toolkit.removeAWTEventListener(this.keyListener);
        }
        if (enabled) {
            this.rootPane.getGlassPane().addMouseMotionListener(this.mouseMotionListener);
        } else {
            this.rootPane.getGlassPane().removeMouseMotionListener(this.mouseMotionListener);
        }
        if (enabled) {
            this.window = SwingUtilities.windowForComponent(this.rootPane);
            if (this.window != null) {
                this.window.addWindowListener(this.windowListener);
            }
        } else if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window = null;
        }
        if (enabled) {
            Point pt = new Point(MouseInfo.getPointerInfo().getLocation());
            SwingUtilities.convertPointFromScreen(pt, this.rootPane);
            this.lastX = pt.x;
            this.lastY = pt.y;
            this.inspect(this.lastX, this.lastY);
        } else {
            this.lastComponent = null;
            this.inspectParentLevel = 0;
            if (this.highlightFigure != null) {
                this.highlightFigure.getParent().remove(this.highlightFigure);
            }
            this.highlightFigure = null;
            this.hidePopup();
        }
        this.propertyChangeSupport.firePropertyChange("enabled", !enabled, enabled);
    }

    private void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    public void update() {
        if (!this.rootPane.getGlassPane().isVisible()) {
            return;
        }
        EventQueue.invokeLater(() -> {
            this.setEnabled(false);
            this.setEnabled(true);
            this.inspect(this.lastX, this.lastY);
        });
    }

    private int inspect(int x2, int y2) {
        Container parent;
        Point pt = SwingUtilities.convertPoint(this.rootPane.getGlassPane(), x2, y2, this.rootPane);
        Component c2 = this.getDeepestComponentAt(this.rootPane, pt.x, pt.y);
        int parentLevel = 0;
        for (int i2 = 0; i2 < this.inspectParentLevel && c2 != null && (parent = c2.getParent()) != null; ++i2) {
            c2 = parent;
            ++parentLevel;
        }
        if (c2 == this.lastComponent) {
            return parentLevel;
        }
        this.lastComponent = c2;
        this.highlight(c2);
        this.showToolTip(c2, x2, y2, parentLevel);
        return parentLevel;
    }

    private Component getDeepestComponentAt(Component parent, int x2, int y2) {
        if (!parent.contains(x2, y2)) {
            return null;
        }
        if (parent instanceof Container) {
            for (Component child : ((Container)parent).getComponents()) {
                Component c2;
                if (child == null || !child.isVisible()) continue;
                int cx2 = x2 - child.getX();
                int cy2 = y2 - child.getY();
                Component component = c2 = child instanceof Container ? this.getDeepestComponentAt(child, cx2, cy2) : child.getComponentAt(cx2, cy2);
                if (c2 == null || !c2.isVisible() || c2 == this.highlightFigure || c2.getParent() instanceof JRootPane && c2 == ((JRootPane)c2.getParent()).getGlassPane() || "com.formdev.flatlaf.ui.FlatWindowResizer".equals(c2.getClass().getName())) continue;
                return c2;
            }
        }
        return parent;
    }

    private void highlight(Component c2) {
        if (this.highlightFigure == null) {
            this.highlightFigure = this.createHighlightFigure();
            this.rootPane.getLayeredPane().add((Component)this.highlightFigure, HIGHLIGHT_LAYER);
        }
        this.highlightFigure.setVisible(c2 != null);
        if (c2 != null) {
            Insets insets = this.rootPane.getInsets();
            this.highlightFigure.setBounds(new Rectangle(SwingUtilities.convertPoint(c2, -insets.left, -insets.top, this.rootPane), c2.getSize()));
        }
    }

    private JComponent createHighlightFigure() {
        JComponent c2 = new JComponent(){

            @Override
            protected void paintComponent(Graphics g2) {
                g2.setColor(this.getBackground());
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            }

            @Override
            protected void paintBorder(Graphics g2) {
                Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g2);
                super.paintBorder(g2);
                FlatUIUtils.resetRenderingHints(g2, oldRenderingHints);
            }
        };
        c2.setBackground(new Color(255, 0, 0, 32));
        c2.setBorder(new LineBorder(Color.red));
        return c2;
    }

    private void showToolTip(Component c2, int x2, int y2, int parentLevel) {
        this.hidePopup();
        if (c2 == null || this.window != null && !this.window.isActive()) {
            return;
        }
        JToolTip tip = new JToolTip();
        tip.setTipText(FlatInspector.buildToolTipText(c2, parentLevel, this.showClassHierarchy));
        tip.putClientProperty("Popup.forceHeavyWeight", true);
        Point pt = new Point(x2, y2);
        SwingUtilities.convertPointToScreen(pt, this.rootPane.getGlassPane());
        int tx = pt.x + UIScale.scale(8);
        int ty = pt.y + UIScale.scale(16);
        Dimension size = tip.getPreferredSize();
        Rectangle visibleRect = this.rootPane.getGraphicsConfiguration().getBounds();
        if (tx + size.width > visibleRect.x + visibleRect.width) {
            tx -= size.width + UIScale.scale(16);
        }
        if (ty + size.height > visibleRect.y + visibleRect.height) {
            ty -= size.height + UIScale.scale(32);
        }
        if (tx < visibleRect.x) {
            tx = visibleRect.x;
        }
        if (ty < visibleRect.y) {
            ty = visibleRect.y;
        }
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.popup = popupFactory.getPopup(c2, tip, tx, ty);
        this.popup.show();
    }

    private static String buildToolTipText(Component c2, int parentLevel, boolean classHierarchy) {
        LayoutManager layout;
        StringBuilder buf = new StringBuilder(1500);
        buf.append("<html><style>");
        buf.append("td { padding: 0 10 0 0; }");
        buf.append("</style><table>");
        FlatInspector.appendRow(buf, "Class", FlatInspector.toString(c2.getClass(), classHierarchy));
        FlatInspector.appendRow(buf, "Size", c2.getWidth() + ", " + c2.getHeight() + "&nbsp;&nbsp; @ " + c2.getX() + ", " + c2.getY());
        if (c2 instanceof Container) {
            FlatInspector.appendRow(buf, "Insets", FlatInspector.toString(((Container)c2).getInsets()));
        }
        Insets margin = null;
        if (c2 instanceof AbstractButton) {
            margin = ((AbstractButton)c2).getMargin();
        } else if (c2 instanceof JTextComponent) {
            margin = ((JTextComponent)c2).getMargin();
        } else if (c2 instanceof JMenuBar) {
            margin = ((JMenuBar)c2).getMargin();
        } else if (c2 instanceof JToolBar) {
            margin = ((JToolBar)c2).getMargin();
        }
        if (margin != null) {
            FlatInspector.appendRow(buf, "Margin", FlatInspector.toString(margin));
        }
        if (c2 instanceof JComponent) {
            Insets visualPadding;
            Object value = ((JComponent)c2).getClientProperty(MigLayoutVisualPadding.VISUAL_PADDING_PROPERTY);
            Insets insets = value instanceof int[] ? new Insets(((int[])value)[0], ((int[])value)[1], ((int[])value)[2], ((int[])value)[3]) : (visualPadding = value instanceof Insets ? (Insets)value : null);
            if (visualPadding != null) {
                FlatInspector.appendRow(buf, "Mig visual padding", FlatInspector.toString(visualPadding));
            }
        }
        Dimension prefSize = c2.getPreferredSize();
        Dimension minSize = c2.getMinimumSize();
        Dimension maxSize = c2.getMaximumSize();
        FlatInspector.appendRow(buf, "Pref size", prefSize.width + ", " + prefSize.height);
        FlatInspector.appendRow(buf, "Min size", minSize.width + ", " + minSize.height);
        FlatInspector.appendRow(buf, "Max size", maxSize.width + ", " + maxSize.height);
        if (c2 instanceof JComponent) {
            FlatInspector.appendRow(buf, "Border", FlatInspector.toString(((JComponent)c2).getBorder(), classHierarchy));
        }
        FlatInspector.appendRow(buf, "Background", FlatInspector.toString(c2.getBackground()) + (c2.isBackgroundSet() ? "" : "  NOT SET"));
        FlatInspector.appendRow(buf, "Foreground", FlatInspector.toString(c2.getForeground()) + (c2.isForegroundSet() ? "" : "  NOT SET"));
        FlatInspector.appendRow(buf, "Font", FlatInspector.toString(c2.getFont()) + (c2.isFontSet() ? "" : "  NOT SET"));
        if (c2 instanceof JComponent) {
            try {
                Object ui;
                if (SystemInfo.isJava_9_orLater) {
                    Method m2 = JComponent.class.getMethod("getUI", new Class[0]);
                    ui = m2.invoke((Object)c2, new Object[0]);
                } else {
                    Field f2 = JComponent.class.getDeclaredField("ui");
                    f2.setAccessible(true);
                    ui = f2.get(c2);
                }
                FlatInspector.appendRow(buf, "UI", ui != null ? FlatInspector.toString(ui.getClass(), classHierarchy) : "null");
            }
            catch (Exception ui) {
                // empty catch block
            }
        }
        if (c2 instanceof Container && (layout = ((Container)c2).getLayout()) != null) {
            FlatInspector.appendRow(buf, "Layout", FlatInspector.toString(layout.getClass(), classHierarchy));
        }
        FlatInspector.appendRow(buf, "Enabled", String.valueOf(c2.isEnabled()));
        FlatInspector.appendRow(buf, "Opaque", String.valueOf(c2.isOpaque()) + (c2 instanceof JComponent && FlatUIUtils.hasOpaqueBeenExplicitlySet((JComponent)c2) ? " EXPLICIT" : ""));
        if (c2 instanceof AbstractButton) {
            FlatInspector.appendRow(buf, "ContentAreaFilled", String.valueOf(((AbstractButton)c2).isContentAreaFilled()));
        }
        FlatInspector.appendRow(buf, "Focusable", String.valueOf(c2.isFocusable()));
        FlatInspector.appendRow(buf, "Left-to-right", String.valueOf(c2.getComponentOrientation().isLeftToRight()));
        FlatInspector.appendRow(buf, "Parent", c2.getParent() != null ? FlatInspector.toString(c2.getParent().getClass(), classHierarchy) : "null");
        buf.append("<tr><td colspan=\"2\">");
        if (parentLevel > 0) {
            buf.append("<br>Parent level: " + parentLevel);
        }
        buf.append("<br>(").append(parentLevel > 0 ? "press <b>Ctrl/Shift</b> to increase/decrease level" : "press <b>Ctrl</b> key to inspect parent").append("; &nbsp;").append(classHierarchy ? "press <b>Alt</b> key to hide class hierarchy" : "press <b>Alt</b> key to show class hierarchy").append(')');
        buf.append("</td></tr>");
        buf.append("</table></html>");
        return buf.toString();
    }

    private static void appendRow(StringBuilder buf, String key, String value) {
        buf.append("<tr><td valign=\"top\">").append(key).append(":</td><td>").append(value).append("</td></tr>");
    }

    private static String toString(Class<?> cls, boolean classHierarchy) {
        StringBuilder buf = new StringBuilder(100);
        int level = 0;
        while (cls != null) {
            if (level > 0) {
                if (cls == Object.class) break;
                buf.append("<br>&nbsp;");
                for (int i2 = 1; i2 < level; ++i2) {
                    buf.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                }
                buf.append("\u2570 ");
            }
            ++level;
            String name = cls.getName();
            int dot = name.lastIndexOf(46);
            String pkg = dot >= 0 ? name.substring(0, dot) : "-";
            String simpleName = dot >= 0 ? name.substring(dot + 1) : name;
            buf.append(simpleName).append(' ').append(FlatInspector.toDimmedText("(" + pkg + ")"));
            if (UIResource.class.isAssignableFrom(cls)) {
                buf.append(" UI");
            }
            if (!classHierarchy) break;
            cls = cls.getSuperclass();
        }
        return buf.toString();
    }

    private static String toString(Insets insets) {
        if (insets == null) {
            return "null";
        }
        return insets.top + ", " + insets.left + ", " + insets.bottom + ", " + insets.right + (insets instanceof UIResource ? " UI" : "");
    }

    private static String toString(Color c2) {
        if (c2 == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder(150);
        buf.append("<tt>");
        buf.append(c2.getAlpha() != 255 ? String.format("#%06x%02x", c2.getRGB() & 0xFFFFFF, c2.getRGB() >> 24 & 0xFF) : String.format("#%06x", c2.getRGB() & 0xFFFFFF));
        buf.append("</tt>");
        if (c2 instanceof UIResource) {
            buf.append(" UI");
        }
        buf.append("&nbsp; &nbsp;").append("<span style=\"background: ").append(String.format("#%06x", c2.getRGB() & 0xFFFFFF)).append(";\">").append("&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;").append("</span>");
        if (c2.getAlpha() != 255) {
            buf.append(" ").append(Math.round((float)c2.getAlpha() / 2.55f)).append('%');
        }
        return buf.toString();
    }

    private static String toString(Font f2) {
        if (f2 == null) {
            return "null";
        }
        return f2.getFamily() + " " + f2.getSize() + " " + f2.getStyle() + (f2 instanceof UIResource ? " UI" : "");
    }

    private static String toString(Border b2, boolean classHierarchy) {
        if (b2 == null) {
            return "null";
        }
        String s2 = FlatInspector.toString(b2.getClass(), classHierarchy);
        if (b2 instanceof EmptyBorder) {
            String borderInsets = " (" + FlatInspector.toString(((EmptyBorder)b2).getBorderInsets()) + ')';
            int brIndex = s2.indexOf("<br>");
            s2 = brIndex >= 0 ? s2.substring(0, brIndex) + borderInsets + s2.substring(brIndex) : s2 + borderInsets;
        }
        return s2;
    }

    private static String toDimmedText(String text) {
        Color color = UIManager.getColor("Label.disabledForeground");
        if (color == null) {
            color = UIManager.getColor("Label.disabledText");
        }
        if (color == null) {
            color = Color.GRAY;
        }
        return String.format("<span color=\"#%06x\">%s</span>", color.getRGB() & 0xFFFFFF, text);
    }
}

